/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.dialogs;

import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.model.AMSQLObject;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlSchema;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.metadata.MTables;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpression;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class UsedColumnsDialog
extends ATitledDialog {
    private TreeViewer treeViewer;
    private MRoot root;
    private List<MSQLColumn> cols = new ArrayList<MSQLColumn>();
    private List<MSqlTable> tables;
    private List<AMSQLObject> columns;

    public UsedColumnsDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle("Columns Dialog");
        this.setDefaultSize(650, 780);
    }

    public void setRoot(MRoot root) {
        this.root = root;
    }

    public void setSelection(ANode sel) {
        this.tables = Util.getTables(sel);
        if (!(sel instanceof MExpression)) {
            this.columns = Util.getUsedColumns(sel);
        }
    }

    public boolean close() {
        TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
        for (Object obj : ts.toList()) {
            if (!(obj instanceof MSQLColumn)) continue;
            this.cols.add((MSQLColumn)obj);
        }
        return super.close();
    }

    public List<MSQLColumn> getColumns() {
        return this.cols;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        this.treeViewer = new TreeViewer(cmp, 2052);
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof MRoot) {
                    ArrayList<INode> n = new ArrayList<INode>();
                    MRoot p = (MRoot)parentElement;
                    for (INode node : p.getChildren()) {
                        if (!(node instanceof MSqlSchema) || this.getChildrens4Schema((MSqlSchema)node).length <= 0) continue;
                        n.add(node);
                    }
                    return n.toArray();
                }
                if (parentElement instanceof MSqlSchema) {
                    return this.getChildrens4Schema((MSqlSchema)parentElement);
                }
                if (parentElement instanceof MTables) {
                    return this.getChildrens4Tables((MTables)((Object)parentElement));
                }
                return super.getChildren(parentElement);
            }

            protected Object[] getChildrens4Schema(MSqlSchema p) {
                if (p.getChildren() != null && p.getChildren().size() > 0) {
                    ArrayList<INode> n = new ArrayList<INode>();
                    for (INode node : p.getChildren()) {
                        if (!(node instanceof MTables) || this.getChildrens4Tables((MTables)node).length <= 0) continue;
                        n.add(node);
                    }
                    return n.toArray();
                }
                return new Object[0];
            }

            protected Object[] getChildrens4Tables(MTables p) {
                if (p.getChildren() != null && p.getChildren().size() > 0) {
                    ArrayList<INode> n = new ArrayList<INode>();
                    for (INode node : p.getChildren()) {
                        if (!UsedColumnsDialog.this.tables.contains(node)) continue;
                        n.add(node);
                    }
                    return n.toArray();
                }
                return new Object[0];
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        GridData gd = new GridData(1808);
        gd.minimumHeight = 400;
        gd.minimumWidth = 400;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection ts = (TreeSelection)UsedColumnsDialog.this.treeViewer.getSelection();
                Object el = ts.getFirstElement();
                if (el instanceof MSQLColumn) {
                    UsedColumnsDialog.this.okPressed();
                } else if (UsedColumnsDialog.this.treeViewer.getExpandedState(el)) {
                    UsedColumnsDialog.this.treeViewer.collapseToLevel(el, 1);
                } else {
                    UsedColumnsDialog.this.treeViewer.expandToLevel(el, 1);
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection ts = (TreeSelection)UsedColumnsDialog.this.treeViewer.getSelection();
                Object el = ts.getFirstElement();
                UsedColumnsDialog.this.getButton(0).setEnabled(el instanceof MSQLColumn);
            }
        });
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.expandAll();
        return cmp;
    }
}

