/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.model;

import com.jaspersoft.studio.data.sql.model.MDBObjects;
import com.jaspersoft.studio.data.sql.model.MSQLRoot;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlSchema;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.IQueryString;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.model.ANode;
import net.sf.jasperreports.eclipse.util.Misc;

public class AMSQLObject
extends MDBObjects
implements IQueryString {
    public static final long serialVersionUID = 10200L;

    public AMSQLObject(ANode parent, String value, String image) {
        super(parent, value, image);
    }

    @Override
    public String getToolTip() {
        String name = ConvertUtil.cleanDbNameFull(this.toSQLString());
        if (this.tooltip != null) {
            name = String.valueOf(name) + this.tooltip;
        }
        return name;
    }

    @Override
    public String toSQLString() {
        String str = this.getValue();
        if (str == null || str.isEmpty()) {
            return "";
        }
        ANode p = this.getParent();
        MSQLRoot r = this.getRoot();
        if (r == null) {
            return "(...)";
        }
        String IQ = r.getIdentifierQuote();
        boolean onlyException = r.isQuoteExceptions();
        while (p != null) {
            if (p instanceof AMSQLObject) {
                if (p instanceof MSqlSchema && ((MSqlSchema)p).isCurrent()) {
                    return Misc.quote((String)str, (String)IQ, (boolean)onlyException);
                }
                String s = ((AMSQLObject)p).toSQLString();
                if (Misc.isNullOrEmpty((String)s)) {
                    return Misc.quote((String)str, (String)IQ, (boolean)onlyException);
                }
                if (this instanceof MSqlTable && r.isSchemaTableQuote()) {
                    String t = String.valueOf(s) + "." + Misc.quote((String)str, (String)IQ, (boolean)onlyException);
                    t = t.replaceAll(IQ, "");
                    t = Misc.quote((String)t, (String)IQ, (boolean)onlyException);
                    return t;
                }
                return String.valueOf(s) + "." + Misc.quote((String)this.getValue(), (String)IQ, (boolean)onlyException);
            }
            p = p.getParent();
        }
        if (this instanceof MSqlSchema) {
            return Misc.quote((String)str, (String)IQ, (boolean)onlyException);
        }
        if (this instanceof MSqlTable) {
            return Misc.quote((String)str, (String)IQ, (boolean)onlyException);
        }
        return str;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AMSQLObject && ((AMSQLObject)obj).toSQLString().equals(this.toSQLString());
    }

    @Override
    public int hashCode() {
        return this.toSQLString().hashCode();
    }
}

