/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.text2model;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.SelectQuery;
import com.jaspersoft.studio.data.sql.SelectSubSet;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.action.union.CreateUnion;
import com.jaspersoft.studio.data.sql.impl.ModelImpl;
import com.jaspersoft.studio.data.sql.impl.SelectImpl;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.MSQLRoot;
import com.jaspersoft.studio.data.sql.model.query.MHaving;
import com.jaspersoft.studio.data.sql.model.query.MUnion;
import com.jaspersoft.studio.data.sql.model.query.MWhere;
import com.jaspersoft.studio.data.sql.text2model.ConvertExpression;
import com.jaspersoft.studio.data.sql.text2model.ConvertFetchFirst;
import com.jaspersoft.studio.data.sql.text2model.ConvertGroupBy;
import com.jaspersoft.studio.data.sql.text2model.ConvertLimit;
import com.jaspersoft.studio.data.sql.text2model.ConvertOffset;
import com.jaspersoft.studio.data.sql.text2model.ConvertOrderBy;
import com.jaspersoft.studio.data.sql.text2model.ConvertSelectColumns;
import com.jaspersoft.studio.data.sql.text2model.ConvertTables;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.model.ANode;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class Text2Model {
    private static boolean isRunning = false;

    public static void text2model(SQLQueryDesigner designer, XtextDocument doc) {
        Text2Model.text2model(designer, doc, false);
    }

    public static void text2model(final SQLQueryDesigner designer, final XtextDocument doc, final boolean showWarning) {
        try {
            if (isRunning) {
                return;
            }
            isRunning = true;
            designer.refreshViewer();
            ConvertUtil.cleanDBMetadata(designer.getDbMetadata().getRoot());
            doc.readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

                public String exec(XtextResource resource) {
                    if (!resource.getErrors().isEmpty()) {
                        if (showWarning && !doc.get().trim().isEmpty()) {
                            UIUtils.showWarning((String)Messages.Text2Model_warn);
                        }
                        isRunning = false;
                        return "";
                    }
                    designer.showInfo("");
                    MSQLRoot root = designer.getRoot();
                    EList list = resource.getContents();
                    if (list != null && !list.isEmpty()) {
                        for (Object obj : list) {
                            SelectQuery sq;
                            if (obj instanceof ModelImpl && (sq = ((ModelImpl)obj).getQuery()) instanceof SelectImpl) {
                                Text2Model.convertSelect(designer, (ANode)root, (SelectImpl)sq);
                                EList op = ((SelectImpl)sq).getOp();
                                if (op != null && !op.isEmpty()) {
                                    for (SelectSubSet sss : op) {
                                        MUnion munion = null;
                                        if (sss.getOp() != null) {
                                            munion = CreateUnion.createUnion((ANode)root);
                                            String setop = sss.getOp().toUpperCase();
                                            if (setop.equals("UNION") && sss.getAll() != null) {
                                                setop = String.valueOf(setop) + " ALL";
                                            }
                                            munion.setValue(setop);
                                        }
                                        Text2Model.convertSelect(designer, (ANode)Misc.nvl((Object)munion, (Object)((Object)root)), (SelectImpl)sss.getQuery());
                                    }
                                }
                            }
                            ConvertOrderBy.convertOrderBy(designer, ((SelectImpl)((ModelImpl)obj).getQuery()).getOrderByEntry());
                            ConvertLimit.convertLimit(designer, ((SelectImpl)((ModelImpl)obj).getQuery()).getLim());
                            ConvertOffset.convertOffset(designer, ((SelectImpl)((ModelImpl)obj).getQuery()).getOffset());
                            ConvertFetchFirst.convertFetchFirst(designer, ((SelectImpl)((ModelImpl)obj).getQuery()).getFetchFirst());
                        }
                    }
                    designer.refreshModel();
                    isRunning = false;
                    return "";
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void convertSelect(SQLQueryDesigner designer, ANode qroot, SelectImpl sel) {
        ConvertTables.convertTables(designer, qroot, sel.getTbl());
        ConvertSelectColumns.convertSelectColumns(designer, qroot, sel.getCols());
        ConvertExpression.convertExpression(designer, qroot, (ANode)Util.getKeyword(qroot, MWhere.class), sel.getWhereExpression());
        ConvertGroupBy.convertGroupBy(designer, qroot, sel.getGroupByEntry());
        ConvertExpression.convertExpression(designer, qroot, (ANode)Util.getKeyword(qroot, MHaving.class), sel.getHavingEntry());
    }
}

