/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui;

import com.google.inject.Injector;
import com.jaspersoft.studio.data.sql.Activator;
import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.model.AMSQLObject;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.jasperreports.engine.JRParameter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class SQLQuerySource {
    private SQLQueryDesigner designer;
    private XtextSourceViewer viewer;
    private boolean isDirty = false;
    private EmbeddedEditor embeddedEditor;

    public SQLQuerySource(SQLQueryDesigner designer) {
        this.designer = designer;
    }

    private Injector getInjector() {
        return Activator.getInstance().getInjector("com.jaspersoft.studio.data.Sql");
    }

    private Color getMarginColor() {
        return UIUtil.getColor((String)"org.eclipse.ui.editors.lineNumberRulerColor");
    }

    public Control createSource(Composite parent) {
        Composite cmp = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cmp.setLayout((Layout)layout);
        IEditedResourceProvider resourceProvider = new IEditedResourceProvider(){

            public XtextResource createResource() {
                Injector injector = SQLQuerySource.this.getInjector();
                XtextResourceSet rs = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
                rs.setClasspathURIContext(this.getClass());
                IResourceFactory resourceFactory = (IResourceFactory)injector.getInstance(IResourceFactory.class);
                URI uri = URI.createURI((String)"website/My2.website");
                XtextResource resource = (XtextResource)resourceFactory.createResource(uri);
                rs.getResources().add((Object)resource);
                EcoreUtil.resolveAll((Resource)resource);
                resource.getErrors().isEmpty();
                return resource;
            }
        };
        Injector injector = this.getInjector();
        EmbeddedEditorFactory factory = (EmbeddedEditorFactory)injector.getInstance(EmbeddedEditorFactory.class);
        this.embeddedEditor = factory.newEditor(resourceProvider).showErrorAndWarningAnnotations().withParent(cmp);
        this.embeddedEditor.createPartialEditor();
        this.viewer = this.embeddedEditor.getViewer();
        LineNumberRulerColumn lnrc = new LineNumberRulerColumn();
        this.viewer.addVerticalRulerColumn((IVerticalRulerColumn)lnrc);
        this.viewer.showAnnotations(true);
        try {
            Method m = SourceViewer.class.getDeclaredMethod("getVerticalRuler", new Class[0]);
            m.setAccessible(true);
            IVerticalRuler ivr = (IVerticalRuler)m.invoke((Object)this.embeddedEditor.getViewer(), new Object[0]);
            if (ivr instanceof CompositeRuler) {
                CompositeRuler cfr_ignored_0 = (CompositeRuler)ivr;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        MarginPainter fMarginPainter = new MarginPainter((ITextViewer)this.viewer);
        fMarginPainter.setMarginRulerColumn(0);
        fMarginPainter.setMarginRulerColor(this.getMarginColor());
        this.viewer.addPainter((IPainter)fMarginPainter);
        this.viewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                SQLQuerySource.this.designer.doSourceTextChanged();
                if (SQLQuerySource.this.designer.getActiveEditor() == SQLQuerySource.this) {
                    SQLQuerySource.this.setDirty(true);
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        DropTarget target = new DropTarget((Control)this.viewer.getTextWidget(), 3);
        target.setTransfer(new Transfer[]{NodeTransfer.getInstance(), TemplateTransfer.getInstance(), PluginTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new StyledTextDropTargetEffect(this.viewer.getTextWidget()){

            public void drop(DropTargetEvent event) {
                Object[] arr;
                Object obj = event.data;
                if (obj.getClass().isArray() && (arr = (Object[])obj).length > 0) {
                    obj = arr[0];
                }
                String txt = null;
                if (obj instanceof AMSQLObject) {
                    this.performCustomDropOperations((AMSQLObject)obj);
                    txt = " " + ((AMSQLObject)obj).toSQLString() + " ";
                } else if (obj instanceof JRParameter) {
                    txt = " $P{" + ((JRParameter)obj).getName() + "} ";
                }
                if (txt != null) {
                    IDocument doc = SQLQuerySource.this.viewer.getDocument();
                    int cOffset = SQLQuerySource.this.viewer.getTextWidget().getCaretOffset();
                    try {
                        doc.replace(cOffset, 0, txt);
                    }
                    catch (BadLocationException badLocationException) {
                        StringBuffer oldText = new StringBuffer(SQLQuerySource.this.getQuery());
                        oldText.insert(cOffset, txt);
                        doc.set(oldText.toString());
                    }
                }
            }

            private void performCustomDropOperations(AMSQLObject obj) {
                if (obj instanceof MSqlTable) {
                    SQLQuerySource.this.designer.getDbMetadata().loadTable((MSqlTable)obj);
                }
            }
        });
        this.viewer.getTextWidget().setData("SQLQUERYDESIGNER", (Object)this.designer);
        return cmp;
    }

    public String getQuery() {
        return this.viewer.getDocument().get();
    }

    public void setQuery(String txt) {
        this.viewer.getDocument().set(txt);
        this.setDirty(false);
    }

    public void dispose() {
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public XtextDocument getXTextDocument() {
        return (XtextDocument)this.viewer.getDocument();
    }

    public void setupFont(JasperReportsConfiguration jConfig) {
        this.viewer.getTextWidget().setFont(FontUtils.getEditorsFont((JasperReportsConfiguration)jConfig));
    }
}

