/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.command;

import com.jaspersoft.studio.model.AMapElement;
import com.jaspersoft.studio.model.ANode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.KeyValue;
import org.eclipse.gef.commands.Command;

public abstract class ACommand
extends Command {
    protected Set<ANode> undoRemove;
    protected Map<ANode, KeyValue<ANode, Integer>> undoAdd;
    protected Map<ANode, Map<String, Object>> undoProperties;
    protected List<Command> undoCmd;
    private ANode root;

    public void execute() {
        if (this.undoRemove == null) {
            this.undoRemove = new HashSet<ANode>();
        }
        if (this.undoAdd == null) {
            this.undoAdd = new HashMap<ANode, KeyValue<ANode, Integer>>();
        }
        if (this.undoProperties == null) {
            this.undoProperties = new HashMap<ANode, Map<String, Object>>();
        }
        if (this.undoCmd == null) {
            this.undoCmd = new ArrayList<Command>();
        }
    }

    protected void reparent(ANode n, ANode p) {
        ANode parent = n.getParent();
        if (parent != null) {
            this.undoAdd.put(n, (KeyValue<ANode, Integer>)new KeyValue((Object)parent, (Object)parent.getChildren().indexOf(n)));
        }
        if (p != null) {
            this.undoRemove.add(n);
        }
        n.setParent(p, -1);
    }

    private void findRoot() {
        this.root = null;
        for (ANode p : this.undoRemove) {
            if (this.root != null) {
                return;
            }
            this.root = (ANode)p.getRoot();
        }
        for (ANode p : this.undoAdd.keySet()) {
            if (this.root != null) {
                return;
            }
            this.root = (ANode)p.getRoot();
        }
        for (ANode p : this.undoProperties.keySet()) {
            if (this.root != null) {
                return;
            }
            this.root = (ANode)p.getRoot();
        }
    }

    public void undo() {
        this.findRoot();
        for (Command c : this.undoCmd) {
            c.undo();
        }
        for (ANode p : this.undoRemove) {
            p.setParent(null, -1);
        }
        for (ANode p : this.undoAdd.keySet()) {
            KeyValue<ANode, Integer> parent = this.undoAdd.get(p);
            p.setParent((ANode)parent.key, ((Integer)parent.value).intValue());
        }
        for (ANode p : this.undoProperties.keySet()) {
            AMapElement ame = (AMapElement)p;
            ame.copyProperties(this.undoProperties.get(p));
        }
        if (!(this.undoRemove.isEmpty() && this.undoAdd.isEmpty() && this.undoProperties.isEmpty())) {
            this.firePropertyChange();
        }
    }

    protected void firePropertyChange() {
        if (this.root != null) {
            this.root.getPropertyChangeSupport().firePropertyChange("wrongvalue", true, false);
        }
    }
}

