/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.command;

import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.ISubQuery;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.AMQueryObject;
import com.jaspersoft.studio.data.sql.model.query.from.MFrom;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupBy;
import com.jaspersoft.studio.data.sql.model.query.groupby.MGroupByColumn;
import com.jaspersoft.studio.data.sql.model.query.orderby.MOrderBy;
import com.jaspersoft.studio.data.sql.model.query.orderby.MOrderByColumn;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.gef.commands.Command;

public class DeleteCommand
extends Command {
    private MFromTable node;
    private ANode parent;
    private Map<ANode, ANode> mapDel;
    private Map<ANode, Integer> mapDelIndex;
    private Map<ANode, ANode> mapAdd;
    private Map<ANode, Integer> mapAddIndex;
    private String dropsubquery = "ask";

    public DeleteCommand(MFromTable node) {
        this.node = node;
        this.parent = node.getParent();
    }

    public void setDropSubquery(String dropsubquery) {
        this.dropsubquery = dropsubquery;
    }

    public void execute() {
        if (this.mapDel == null) {
            this.mapDel = new HashMap<ANode, ANode>();
            this.mapDelIndex = new HashMap<ANode, Integer>();
            this.mapAdd = new HashMap<ANode, ANode>();
            this.mapAddIndex = new HashMap<ANode, Integer>();
            this.mapDel.put((ANode)this.node, this.parent);
            int indx = this.node.getParent().getChildren().indexOf(this.node);
            this.mapDelIndex.put((ANode)this.node, indx);
            if (!(this.node instanceof MFromTableJoin) && !this.node.getChildren().isEmpty()) {
                int i = 0;
                for (INode n : this.node.getChildren()) {
                    if (n instanceof MFromTable) {
                        MFromTable mft = new MFromTable(null, (MSqlTable)((MFromTable)n).getValue());
                        mft.setAlias(((MFromTable)n).getAlias());
                        mft.setAliasKeyword(((MFromTable)n).getAliasKeyword());
                        this.node.copyProperties((MFromTable)n);
                        this.mapAdd.put((ANode)mft, this.node.getParent());
                        this.mapAddIndex.put((ANode)mft, indx + i);
                    }
                    ++i;
                }
            }
            this.doDeleteMore(this.parent, this.node);
        }
        for (ANode mft : this.mapDel.keySet()) {
            mft.setParent(null, -1);
        }
        for (ANode mft : this.mapAdd.keySet()) {
            mft.setParent(this.mapAdd.get(mft), this.mapAddIndex.get(mft).intValue());
        }
        this.parent.getRoot().getPropertyChangeSupport().firePropertyChange("wrongvalue", true, false);
    }

    public void undo() {
        for (ANode mft : this.mapAdd.keySet()) {
            mft.setParent(null, -1);
        }
        for (ANode key : this.mapDel.keySet()) {
            key.setParent(this.mapDel.get(key), this.mapDelIndex.get(key).intValue());
        }
        this.parent.getRoot().getPropertyChangeSupport().firePropertyChange("wrongvalue", true, false);
    }

    protected void doDeleteMore(ANode parent, MFromTable todel) {
        if (parent instanceof MFrom && parent.getParent() != null && (parent.getParent() instanceof ISubQuery || parent.getParent().getValue() instanceof MQueryTable) && parent.getChildren().size() <= 1 && parent.getChildren().get(0) == todel) {
            this.dropColumns(parent.getParent(), todel);
            if (this.dropsubquery.equals("drop") || this.dropsubquery.equals("ask") && UIUtils.showConfirmation((String)Messages.DeleteCommand_2, (String)Messages.DeleteCommand_3)) {
                ANode msq = parent.getParent();
                this.mapDel.put(msq, msq.getParent());
                this.mapDelIndex.put(msq, msq.getParent().getChildren().indexOf(msq));
            }
        }
        if (parent.getRoot() != null) {
            this.dropColumns((ANode)parent.getRoot(), todel);
        }
    }

    private void dropColumns(ANode parent, MFromTable todel) {
        for (INode n : parent.getChildren()) {
            AMQueryObject gbc;
            ArrayList<AMQueryObject> toRemove = new ArrayList<AMQueryObject>();
            if (n instanceof MSelect) {
                for (INode iNode : n.getChildren()) {
                    if (!(iNode instanceof MSelectColumn) || ((MSelectColumn)(gbc = (MSelectColumn)iNode)).getMFromTable() == null || !((MSelectColumn)gbc).getMFromTable().equals(todel)) continue;
                    toRemove.add(gbc);
                }
                ((MSelect)n).removeChildren(toRemove);
            } else if (n instanceof MGroupBy) {
                for (INode iNode : n.getChildren()) {
                    gbc = (MGroupByColumn)iNode;
                    if (((MGroupByColumn)gbc).getMFromTable() == null || !((MGroupByColumn)gbc).getMFromTable().equals(todel)) continue;
                    toRemove.add(gbc);
                }
                ((MGroupBy)n).removeChildren(toRemove);
            } else if (n instanceof MOrderBy) {
                for (INode iNode : n.getChildren()) {
                    if (!(iNode instanceof MOrderByColumn) || ((MOrderByColumn)(gbc = (MOrderByColumn)iNode)).getMFromTable() == null || !((MOrderByColumn)gbc).getMFromTable().equals(todel)) continue;
                    toRemove.add(gbc);
                }
                ((MOrderBy)n).removeChildren(toRemove);
            }
            for (ANode aNode : toRemove) {
                ANode p = aNode.getParent();
                if (p == null) continue;
                this.mapDel.put(aNode, p);
                this.mapDelIndex.put(aNode, p.getChildren().indexOf(aNode));
            }
        }
    }
}

