/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.command;

import com.jaspersoft.studio.model.AMapElement;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.commands.Command;

public class SetSilentValuesCommand
extends Command {
    private Map<AMapElement, Map<String, Object>> newVals;
    private Map<AMapElement, Map<String, Object>> oldVals;
    private boolean fireEvent = false;

    public SetSilentValuesCommand(boolean fireEvent) {
        this.fireEvent = fireEvent;
    }

    public void add(AMapElement m, String id, Object val) {
        Map<String, Object> vals;
        if (this.newVals == null) {
            this.newVals = new HashMap<AMapElement, Map<String, Object>>();
        }
        if ((vals = this.newVals.get(m)) == null) {
            vals = new HashMap<String, Object>();
            this.newVals.put(m, vals);
        }
        vals.put(id, val);
    }

    public boolean isEmpty() {
        return this.newVals == null || this.newVals.isEmpty();
    }

    public void execute() {
        if (this.newVals == null) {
            return;
        }
        if (this.oldVals == null) {
            this.oldVals = new HashMap<AMapElement, Map<String, Object>>();
        }
        AMapElement last = null;
        for (AMapElement m : this.newVals.keySet()) {
            Map<String, Object> newvalues = this.newVals.get(m);
            Map<String, Object> oldvalues = this.oldVals.get(m);
            if (oldvalues == null) {
                oldvalues = new HashMap<String, Object>();
                this.oldVals.put(m, oldvalues);
            }
            for (String key : newvalues.keySet()) {
                oldvalues.put(key, m.getPropertyValue((Object)key));
                m.setNoEvents(true);
                m.setPropertyValue((Object)key, newvalues.get(key));
                m.setNoEvents(false);
            }
            last = m;
        }
        if (this.fireEvent && last != null) {
            last.firePropertyChange((Object)"", (Object)true, (Object)false);
        }
    }

    public void undo() {
        AMapElement last = null;
        for (AMapElement m : this.oldVals.keySet()) {
            Map<String, Object> newvalues = this.newVals.get(m);
            Map<String, Object> oldvalues = this.oldVals.get(m);
            for (String key : oldvalues.keySet()) {
                m.setNoEvents(true);
                m.setPropertyValue((Object)key, newvalues.get(key));
                m.setNoEvents(false);
            }
            last = m;
        }
        if (this.fireEvent && last != null) {
            last.firePropertyChange((Object)"", (Object)true, (Object)false);
        }
    }
}

