/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.figures;

import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.data.sql.ui.gef.figures.SqlTableFigure;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Image;

public class ColumnFigure
extends Figure {
    private CheckBox checkbox;
    private boolean refreshing = false;

    public ColumnFigure(String text, Image image) {
        this.setLayoutManager((LayoutManager)new FlowLayout(true));
        this.checkbox = new CheckBox();
        this.checkbox.addChangeListener(new ChangeListener(){

            public void handleStateChanged(ChangeEvent event) {
                if (ColumnFigure.this.refreshing) {
                    return;
                }
                if (event.getPropertyName().equals("selected")) {
                    ColumnFigure.this.handleSelectionChanged();
                }
            }
        });
        this.add((IFigure)this.checkbox);
        Label lbl = new Label(ConvertUtil.cleanDbNameFull(text), image);
        lbl.setTextPlacement(8);
        lbl.setForegroundColor(UIUtils.getSystemColor((int)2));
        this.add((IFigure)lbl);
    }

    public Insets getInsets() {
        return SqlTableFigure.INSETS;
    }

    protected void handleSelectionChanged() {
    }

    public boolean isSelected() {
        return this.checkbox.isSelected();
    }

    public void setSelected(boolean sel) {
        this.refreshing = true;
        this.checkbox.setSelected(sel);
        this.refreshing = false;
    }
}

