/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.layout;

import com.jaspersoft.studio.data.sql.ui.gef.layout.NodeJoiningDirectedGraphLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class DirectedGraphLayoutVisitor {
    private static final Insets PADDING = new Insets(15, 15, 15, 15);
    private Map<AbstractGraphicalEditPart, Object> partToNodesMap;
    private DirectedGraph graph;

    public void layoutDiagram(AbstractGraphicalEditPart diagram) {
        this.partToNodesMap = new HashMap<AbstractGraphicalEditPart, Object>();
        this.graph = new DirectedGraph();
        this.graph.setDirection(16);
        this.addNodes(diagram);
        Rectangle r = diagram.getFigure().getBounds();
        if (r.x < -1000 || r.y < -1000) {
            return;
        }
        if (this.graph.nodes.size() > 0) {
            this.addEdges(diagram);
            new NodeJoiningDirectedGraphLayout().visit(this.graph);
            this.applyChildrenResults(diagram);
        }
    }

    protected void addNodes(AbstractGraphicalEditPart diagram) {
        for (Object obj : diagram.getChildren()) {
            AbstractGraphicalEditPart part = (AbstractGraphicalEditPart)obj;
            Node n = new Node((Object)part);
            Dimension psize = part.getFigure().getPreferredSize(400, 300);
            n.width = psize.width;
            n.height = psize.height;
            n.setPadding(PADDING);
            this.partToNodesMap.put(part, n);
            this.graph.nodes.add((Object)n);
        }
    }

    protected void addEdges(AbstractGraphicalEditPart diagram) {
        for (Object obj : diagram.getChildren()) {
            AbstractGraphicalEditPart part = (AbstractGraphicalEditPart)obj;
            for (Object item : part.getSourceConnections()) {
                AbstractConnectionEditPart rpart = (AbstractConnectionEditPart)item;
                Node source = (Node)this.partToNodesMap.get(rpart.getSource());
                Node target = (Node)this.partToNodesMap.get(rpart.getTarget());
                if (source == null || target == null) continue;
                Edge e = new Edge((Object)rpart, source, target);
                e.weight = 2;
                this.graph.edges.add((Object)e);
                this.partToNodesMap.put((AbstractGraphicalEditPart)rpart, e);
            }
        }
    }

    protected void applyChildrenResults(AbstractGraphicalEditPart diagram) {
        List children = diagram.getChildren();
        Rectangle r = diagram.getFigure().getBounds();
        for (AbstractGraphicalEditPart tp : children) {
            Node n = (Node)this.partToNodesMap.get(tp);
            IFigure f = tp.getFigure();
            Dimension psize = f.getPreferredSize();
            f.setBounds(new Rectangle(r.x + n.x, r.y + n.y, psize.width, psize.height));
            List sc = tp.getSourceConnections();
            for (AbstractConnectionEditPart rp : sc) {
                this.applyResults(rp);
            }
        }
    }

    protected void applyResults(AbstractConnectionEditPart relationshipPart) {
        Edge e = (Edge)this.partToNodesMap.get(relationshipPart);
        if (e == null) {
            return;
        }
        NodeList nodes = e.vNodes;
        PolylineConnection conn = (PolylineConnection)relationshipPart.getConnectionFigure();
        if (nodes != null) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < nodes.size()) {
                Node vn = nodes.getNode(i);
                int x = vn.x;
                int y = vn.y;
                if (e.isFeedback()) {
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    bends.add(new AbsoluteBendpoint(x, y));
                } else {
                    bends.add(new AbsoluteBendpoint(x, y));
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                }
                ++i;
            }
            conn.setRoutingConstraint(bends);
        } else {
            conn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }
}

