/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.gef.parts;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.action.table.EditTable;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.from.TableJoin;
import com.jaspersoft.studio.data.sql.model.query.from.TableJoinDetail;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectExpression;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.data.sql.text2model.ConvertUtil;
import com.jaspersoft.studio.data.sql.ui.gef.anchors.BottomAnchor;
import com.jaspersoft.studio.data.sql.ui.gef.anchors.TopAnchor;
import com.jaspersoft.studio.data.sql.ui.gef.command.DeleteCommand;
import com.jaspersoft.studio.data.sql.ui.gef.figures.SqlTableFigure;
import com.jaspersoft.studio.data.sql.ui.gef.parts.FromEditPart;
import com.jaspersoft.studio.data.sql.ui.gef.policy.TableLayoutEditPolicy;
import com.jaspersoft.studio.data.sql.ui.gef.policy.TableNodeEditPolicy;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MDummy;
import com.jaspersoft.studio.model.util.ModelVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class TableEditPart
extends AbstractGraphicalEditPart {
    private Map<String, MSelectColumn> set = new HashMap<String, MSelectColumn>();
    private SQLQueryDesigner designer;

    public boolean isAllstar() {
        return this.isAllstar(Util.getKeyword((ANode)this.getModel(), MSelect.class));
    }

    public boolean isAllstar(MSelect msel) {
        boolean allstar = false;
        if (msel != null) {
            for (INode n : msel.getChildren()) {
                if (!(n instanceof MSelectExpression) || !n.getValue().equals("*")) continue;
                allstar = true;
                break;
            }
        }
        return allstar;
    }

    protected IFigure createFigure() {
        return new SqlTableFigure(""){

            public IFigure getToolTip() {
                IFigure t = super.getToolTip();
                if (t instanceof Label) {
                    Label l = (Label)t;
                    l.setText(TableEditPart.this.getModel().getDisplayText());
                }
                return t;
            }
        };
    }

    public Map<String, MSelectColumn> getColumnMap() {
        return this.set;
    }

    public MFromTable getModel() {
        return (MFromTable)super.getModel();
    }

    public SqlTableFigure getFigure() {
        return (SqlTableFigure)super.getFigure();
    }

    public FromEditPart getParent() {
        return (FromEditPart)super.getParent();
    }

    protected void refreshVisuals() {
        FromEditPart parent;
        Point p;
        SqlTableFigure f = this.getFigure();
        MFromTable fromTable = this.getModel();
        this.refreshModel();
        f.setToolTip((IFigure)new Label(fromTable.getDisplayText()));
        String sm = (String)fromTable.getPropertyValue("showMode");
        if (sm != null) {
            if (sm.equals("short")) {
                f.setLabelIcon(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/null.png"));
            } else if (sm.equals("keys")) {
                f.setLabelIcon(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/null.png"));
            } else {
                f.setLabelIcon(null);
            }
        }
        if ((p = (parent = this.getParent()).readPoint((APropertyNode)fromTable)) == null) {
            return;
        }
        Point pmin = parent.getMinPoint();
        if (pmin == null) {
            return;
        }
        Insets in = FromEditPart.INSETS;
        p.translate(pmin.getNegated().getTranslated(-in.left, -in.top));
        parent.setLayoutConstraint((EditPart)this, (IFigure)f, new Rectangle(p.x, p.y, -1, -1));
    }

    public void refreshModel() {
        SqlTableFigure f = this.getFigure();
        MFromTable fromTable = this.getModel();
        MSqlTable table = (MSqlTable)fromTable.getValue();
        String tblName = ConvertUtil.cleanDbNameFull(table.getValue());
        if (fromTable.getAlias() != null) {
            tblName = String.valueOf(tblName) + fromTable.getAliasKeyString() + fromTable.getAlias();
        }
        f.setName(tblName);
        MSelect msel = Util.getKeyword((ANode)fromTable, MSelect.class);
        if (msel != null) {
            this.set.clear();
            if (!this.isAllstar(msel)) {
                for (INode n : msel.getChildren()) {
                    if (!(n instanceof MSelectColumn)) continue;
                    MSelectColumn msc = (MSelectColumn)n;
                    if (!((MSelectColumn)n).getMFromTable().equals(fromTable)) continue;
                    this.set.put(((MSQLColumn)msc.getValue()).getValue(), msc);
                }
            }
        }
    }

    protected List<?> getModelChildren() {
        MFromTable m = this.getModel();
        String sm = (String)m.getPropertyValue("showMode");
        MSqlTable tbl = (MSqlTable)m.getValue();
        ArrayList<INode> lst = new ArrayList<INode>();
        if (sm != null && sm.equals("short")) {
            return lst;
        }
        for (INode n : tbl.getChildren()) {
            if (n instanceof MDummy || !(n instanceof MSQLColumn) || sm != null && sm.equals("keys") && ((MSQLColumn)n).getPrimaryKey() == null && ((MSQLColumn)n).getForeignKeys() == null) continue;
            lst.add(n);
        }
        return lst;
    }

    public SQLQueryDesigner getDesigner() {
        if (this.designer == null) {
            this.designer = (SQLQueryDesigner)((Object)this.getViewer().getProperty("SQLQUERYDIAGRAM"));
        }
        return this.designer;
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            EditTable ct = this.getDesigner().getOutline().getAfactory().getAction(EditTable.class);
            if (ct.calculateEnabled(new Object[]{this.getModel()})) {
                ct.run();
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                DeleteCommand cmd = new DeleteCommand(TableEditPart.this.getModel());
                cmd.setDropSubquery(TableEditPart.this.getDesigner().getjConfig().getProperty("com.jaspersoft.studio.data.sql.prefs.delsubquery", "ask"));
                return cmd;
            }
        });
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TableNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TableLayoutEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectionEditPolicy(){

            protected void hideSelection() {
                TableEditPart.this.getFigure().hideSelectedBorder();
            }

            protected void showSelection() {
                TableEditPart.this.getFigure().showSelectedBorder();
            }
        });
    }

    protected boolean isSubQuery(TableJoin tj) {
        return tj.getFromTable().getValue() instanceof MQueryTable || tj.getJoinTable().getValue() instanceof MQueryTable;
    }

    protected List<?> getModelSourceConnections() {
        String dtype = this.getDesigner().getjConfig().getProperty("com.jaspersoft.studio.data.sql.prefs.diagram.type");
        if (dtype != null && dtype.equals("coarse")) {
            if (this.getModel().getTableJoins() != null && !this.getModel().getTableJoins().isEmpty()) {
                ArrayList<TableJoin> joins = new ArrayList<TableJoin>();
                for (TableJoin tj : this.getModel().getTableJoins()) {
                    if (this.isSubQuery(tj)) continue;
                    joins.add(tj);
                }
                return joins;
            }
        } else {
            ArrayList<TableJoinDetail> tjs = new ArrayList<TableJoinDetail>();
            MFromTable m = this.getModel();
            List<TableJoinDetail> joins = m.getTableJoinDetails();
            if (joins != null) {
                for (TableJoinDetail tjd : joins) {
                    this.checkIsConnection(tjs, m, tjd, tjd.getSrcTable());
                }
            }
            if (!tjs.isEmpty()) {
                return tjs;
            }
        }
        return super.getModelSourceConnections();
    }

    protected void checkIsConnection(final List<TableJoinDetail> tjs, final MFromTable m, final TableJoinDetail tjd, MFromTable mft) {
        if (mft.getValue() instanceof MQueryTable) {
            new ModelVisitor<Object>((INode)mft){

                public boolean visit(INode n) {
                    if (n instanceof MFromTable && n.getValue() instanceof MQueryTable) {
                        this.visit(n);
                    } else if (n instanceof MFromTable && n.equals(m)) {
                        tjs.add(tjd);
                        this.stop();
                    }
                    return true;
                }
            };
        } else if (mft.equals(m) || ((MSqlTable)mft.getValue()).equals(m.getValue())) {
            tjs.add(tjd);
        }
    }

    protected List<?> getModelTargetConnections() {
        String dtype = this.getDesigner().getjConfig().getProperty("com.jaspersoft.studio.data.sql.prefs.diagram.type");
        if (dtype != null && dtype.equals("coarse")) {
            if (this.getModel() instanceof MFromTableJoin) {
                ArrayList<TableJoin> joins = new ArrayList<TableJoin>();
                TableJoin tj = ((MFromTableJoin)this.getModel()).getTableJoin();
                if (!this.isSubQuery(tj)) {
                    joins.add(tj);
                }
                return joins;
            }
        } else {
            ArrayList<TableJoinDetail> tjs = new ArrayList<TableJoinDetail>();
            MFromTable m = this.getModel();
            List<TableJoinDetail> joins = m.getTableJoinDetails();
            if (joins != null) {
                for (TableJoinDetail tjd : joins) {
                    this.checkIsConnection(tjs, m, tjd, tjd.getDestTable());
                }
            }
            if (!tjs.isEmpty()) {
                return tjs;
            }
        }
        return super.getModelTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new TopAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new TopAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new BottomAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new BottomAnchor((IFigure)this.getFigure());
    }
}

