/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.ui.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.util.Misc;

public class SchemaUtil {
    public static String[] getSchemaPath(Connection c) {
        String[] res;
        block17: {
            if (c == null) {
                return null;
            }
            try {
                String schema;
                Method m = c.getClass().getMethod("getSchema", new Class[0]);
                if (m != null && !Misc.isNullOrEmpty((String)(schema = (String)m.invoke((Object)c, new Object[0])))) {
                    return new String[]{schema};
                }
            }
            catch (Throwable throwable) {}
            res = null;
            try {
                String dbproduct = c.getMetaData().getDatabaseProductName();
                System.out.println(dbproduct);
                if (dbproduct.equalsIgnoreCase("Oracle")) {
                    try {
                        Method m = c.getClass().getMethod("setIncludeSynonyms", Boolean.TYPE);
                        if (m != null) {
                            m.setAccessible(true);
                            m.invoke((Object)c, true);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    return SchemaUtil.runSchemaQuery(c, "select sys_context('USERENV', 'CURRENT_SCHEMA') from dual");
                }
                if (dbproduct.equalsIgnoreCase("PostgreSQL")) {
                    Statement stmt = c.createStatement();
                    ResultSet rs = stmt.executeQuery("SHOW search_path");
                    while (rs.next()) {
                        String str = rs.getString(1);
                        res = str.split(",");
                    }
                    rs.close();
                    stmt.close();
                    break block17;
                }
                if (dbproduct.equalsIgnoreCase("Apache Hive") || dbproduct.equalsIgnoreCase("ApacheHive")) {
                    return SchemaUtil.runSchemaQuery(c, "SELECT current_database()");
                }
                if (!dbproduct.equalsIgnoreCase("Impala") && !dbproduct.equalsIgnoreCase("Spark SQL")) break block17;
                ArrayList<String> schemas = new ArrayList<String>();
                ResultSet rs = c.getMetaData().getSchemas();
                try {
                    while (rs.next()) {
                        schemas.add(rs.getString("TABLE_SCHEM"));
                    }
                    res = schemas.toArray(new String[schemas.size()]);
                }
                finally {
                    SchemaUtil.close(rs);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public static String getMetadataAllSymbol(DatabaseMetaData dbmeta) throws SQLException {
        String dbproduct = dbmeta.getDatabaseProductName();
        if (dbproduct.equalsIgnoreCase("Apache Hive") || dbproduct.equalsIgnoreCase("Impala") || dbproduct.equalsIgnoreCase("ApacheHive")) {
            return null;
        }
        return "%";
    }

    protected static String[] runSchemaQuery(Connection c, String query) throws SQLException {
        ArrayList<String> paths = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement stmt = c.createStatement();){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (ResultSet rs = stmt.executeQuery(query);){
                while (rs.next()) {
                    String str = rs.getString(1);
                    paths.add(str);
                    System.out.println(str);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        if (!paths.isEmpty()) {
            return paths.toArray(new String[paths.size()]);
        }
        return null;
    }

    public static void close(Connection c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

