/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.widgets;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.data.designer.AQueryDesigner;
import com.jaspersoft.studio.data.designer.ICQuery;
import com.jaspersoft.studio.data.designer.IFilterQuery;
import com.jaspersoft.studio.data.designer.SelectParameterDialog;
import com.jaspersoft.studio.data.jdbc.JDBCFieldsProvider;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.FieldOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.ParameterPOperand;
import com.jaspersoft.studio.data.sql.model.query.operand.ScalarOperand;
import com.jaspersoft.studio.data.sql.widgets.AOperandWidget;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ParameterWidget
extends AOperandWidget<ParameterPOperand>
implements IFilterQuery {
    private Text txt;

    public ParameterWidget(Composite parent, ParameterPOperand operand, AQueryDesigner designer) {
        super(parent, 2048, operand, designer);
    }

    @Override
    protected void createWidget(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.txt = new Text((Composite)this, 8);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        this.txt.setLayoutData((Object)gd);
        ToolBar buttons = new ToolBar((Composite)this, 0x800000);
        ToolItem button = new ToolItem(buttons, 8);
        button.setText("...");
        button.addListener(13, event -> {
            SelectSQLParameterDialog d = new SelectSQLParameterDialog(parent.getShell(), this.designer, this);
            if (d.open() == 0) {
                this.fillValue();
            }
        });
        button.setToolTipText(Messages.FieldWidget_0);
        buttons.setLayoutData((Object)new GridData(2));
        this.fillValue();
    }

    private void fillValue() {
        JRDesignParameter p = ((ParameterPOperand)this.getValue()).getJrParameter();
        if (p != null) {
            this.txt.setText(Misc.nvl((String)p.getName()));
            this.txt.setToolTipText(Misc.nvl((String)p.getName()));
        } else if (((ParameterPOperand)this.getValue()).isShowDialog()) {
            UIUtils.getDisplay().asyncExec(() -> {
                SelectSQLParameterDialog d = new SelectSQLParameterDialog(UIUtils.getShell(), this.designer, this);
                if (d.open() == 0) {
                    this.fillValue();
                }
            });
        }
    }

    public String getFilterQuery() {
        return ParameterWidget.getFilterQueryObject(((ParameterPOperand)this.getValue()).getExpression().getOperands());
    }

    public static String getFilterQueryObject(List<AOperand> ops) {
        for (AOperand aop : ops) {
            if (!(aop instanceof FieldOperand)) continue;
            FieldOperand fop = (FieldOperand)aop;
            ICQuery q = new ICQuery();
            q.query = "SELECT * FROM " + fop.getFromTable().toSQLString();
            q.columns = new ArrayList();
            q.valueField = fop.toSQLString();
            try {
                return new ObjectMapper().writeValueAsString((Object)q);
            }
            catch (JsonProcessingException e) {
                UIUtils.showError((Throwable)e);
            }
        }
        return null;
    }

    public String getLanguage() {
        return "sql";
    }

    class SelectSQLParameterDialog
    extends SelectParameterDialog {
        public SelectSQLParameterDialog(Shell parentShell, AQueryDesigner designer, IFilterQuery fq) {
            super(parentShell, designer, fq);
            if (((ParameterPOperand)ParameterWidget.this.getValue()).getJrParameter() != null) {
                this.pname = ((ParameterPOperand)ParameterWidget.this.getValue()).getJrParameter().getName();
            }
        }

        protected void commitValues() {
            super.commitValues();
            ((ParameterPOperand)ParameterWidget.this.getValue()).setJrParameter(this.prm);
            ParameterWidget.this.fillValue();
        }

        protected void cancelPressed() {
            if (((ParameterPOperand)ParameterWidget.this.getValue()).getJrParameter() == null) {
                super.commitValues();
                ((ParameterPOperand)ParameterWidget.this.getValue()).setJrParameter(this.prm);
            }
            super.cancelPressed();
        }

        protected boolean isParameterCompatible(JRParameter p) {
            for (AOperand aop : ParameterWidget.this.operands) {
                if (aop == ParameterWidget.this.value) continue;
                if (aop instanceof FieldOperand) {
                    if (((FieldOperand)aop).getMColumn() == null) {
                        return true;
                    }
                    String t = ((FieldOperand)aop).getMColumn().getUnformattedTypeName();
                    try {
                        Class clazz = JRClassLoader.loadClassForName((String)JDBCFieldsProvider.getJavaType4SQL((String)t));
                        Class pclazz = p.getValueClass();
                        if (Number.class.isAssignableFrom(pclazz)) {
                            return Number.class.isAssignableFrom(clazz);
                        }
                        return pclazz.isAssignableFrom(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (!(aop instanceof ScalarOperand) || ((ScalarOperand)aop).getType().isAssignableFrom(p.getValueClass())) continue;
                return false;
            }
            return true;
        }

        protected String getDefaultParameterType() {
            if (this.prm != null && this.isParameterCompatible((JRParameter)this.prm)) {
                return this.prm.getValueClassName();
            }
            for (AOperand aop : ParameterWidget.this.operands) {
                if (aop == ParameterWidget.this.value) continue;
                if (aop instanceof FieldOperand) {
                    String t = ((FieldOperand)aop).getMColumn().getUnformattedTypeName();
                    return JDBCFieldsProvider.getJavaType4SQL((String)t);
                }
                if (!(aop instanceof ScalarOperand)) continue;
                return ((ScalarOperand)aop).getType().getCanonicalName();
            }
            return Object.class.getName();
        }
    }
}

