/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.WorkspacePathValidator;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.operations.CheckoutAsProjectOperation;
import org.tigris.subversion.subclipse.ui.util.IPromptCondition;
import org.tigris.subversion.subclipse.ui.util.PromptingDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutUsingProjectWizardAction
extends SVNAction {
    ISVNRemoteFolder[] folders;
    private SVNRevision svnRevision = SVNRevision.HEAD;
    private int depth = 5;
    private boolean ignoreExternals = false;
    private boolean force = true;

    public CheckoutUsingProjectWizardAction(ISVNRemoteFolder[] folders) {
        this.folders = folders;
    }

    @Override
    protected boolean isEnabled() {
        return this.folders.length > 0;
    }

    @Override
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (!WorkspacePathValidator.validateWorkspacePath()) {
            return;
        }
        if (this.folders.length == 1) {
            if (this.folders[0].getRepository().getRepositoryRoot().toString().equals(this.folders[0].getUrl().toString()) && !MessageDialog.openQuestion((Shell)this.shell, (String)Policy.bind("CheckoutAsAction.title"), (String)Policy.bind("AddToWorkspaceAction.checkingOutRoot"))) {
                return;
            }
            this.checkoutSingleProject(this.folders[0]);
        }
    }

    private void checkoutSingleProject(final ISVNRemoteFolder remoteFolder) throws InvocationTargetException, InterruptedException {
        final String remoteFolderName = remoteFolder.getName();
        final boolean[] hasProjectMetaFile = new boolean[1];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    remoteFolder.members(monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, true, 1);
        IProject newProject = null;
        IProjectDescription newDesc = null;
        if (!hasProjectMetaFile[0] && (newProject = this.getNewProject(remoteFolderName)) == null) {
            return;
        }
        final IProject project = newProject;
        final IProjectDescription desc = newDesc;
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(null, 100);
                        monitor.setTaskName(Policy.bind("CheckoutAsAction.taskname", remoteFolderName, project.getName()));
                        int used = 0;
                        if (hasProjectMetaFile[0]) {
                            used = 5;
                            CheckoutUsingProjectWizardAction.this.createAndOpenProject(project, desc, Policy.subMonitorFor(monitor, used));
                        }
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, true, 1);
        CheckoutAsProjectOperation checkoutAsProjectOperation = new CheckoutAsProjectOperation(this.getTargetPart(), new ISVNRemoteFolder[]{remoteFolder}, new IProject[]{project});
        checkoutAsProjectOperation.setSvnRevision(this.svnRevision);
        checkoutAsProjectOperation.setDepth(this.depth);
        checkoutAsProjectOperation.setIgnoreExternals(this.ignoreExternals);
        checkoutAsProjectOperation.setForce(this.force);
        checkoutAsProjectOperation.run();
    }

    private void createAndOpenProject(IProject project, IProjectDescription desc, IProgressMonitor monitor) throws SVNException {
        try {
            try {
                monitor.beginTask(null, 5);
                if (project.exists()) {
                    if (desc != null) {
                        project.move(desc, true, Policy.subMonitorFor(monitor, 3));
                    }
                } else if (desc == null) {
                    project.create(Policy.subMonitorFor(monitor, 3));
                } else {
                    project.create(desc, Policy.subMonitorFor(monitor, 3));
                }
                if (!project.isOpen()) {
                    project.open(Policy.subMonitorFor(monitor, 2));
                }
            }
            catch (CoreException e) {
                throw SVNException.wrapException((CoreException)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private IProject getNewProject(String suggestedName) {
        NewProjectListener listener = new NewProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        IProject project = listener.getNewProject();
        if (project == null) {
            return null;
        }
        try {
            IResource[] members = project.members();
            if (members.length == 0 || members.length == 1 && members[0].getName().equals(".project")) {
                return project;
            }
            PromptingDialog prompt = new PromptingDialog(this.getShell(), (IResource[])new IProject[]{project}, CheckoutUsingProjectWizardAction.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("ReplaceWithAction.confirmOverwrite"));
            try {
                if (prompt.promptForMultiple().length == 1) {
                    return project;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (CoreException e) {
            this.handle((Exception)((Object)e));
        }
        return null;
    }

    @Override
    protected String getErrorTitle() {
        return Policy.bind("CheckoutAsAction.checkoutFailed");
    }

    public static IPromptCondition getOverwriteLocalAndFileSystemPrompt() {
        return new IPromptCondition(){

            @Override
            public boolean needsPrompt(IResource resource) {
                File localLocation = this.getFileLocation(resource);
                return resource.exists() || localLocation.exists();
            }

            @Override
            public String promptMessage(IResource resource) {
                return Policy.bind("CheckoutAsAction.confirmOverwrite", resource.getName());
            }

            private File getFileLocation(IResource resource) {
                return new File(resource.getParent().getLocation().toFile(), resource.getName());
            }
        };
    }

    public void setSvnRevision(SVNRevision svnRevision) {
        this.svnRevision = svnRevision;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    class NewProjectListener
    implements IResourceChangeListener {
        private IProject newProject = null;

        NewProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (delta.getKind() == 1) {
                    this.newProject = (IProject)resource;
                }
                ++i;
            }
        }

        public IProject getNewProject() {
            return this.newProject;
        }
    }
}

