/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.operations.RepositoryBranchTagOperation;
import org.tigris.subversion.subclipse.ui.wizards.BranchTagWizard;
import org.tigris.subversion.subclipse.ui.wizards.SizePersistedWizardDialog;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryBranchTagAction
extends SVNAction {
    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ISVNRemoteResource[] resources = this.getSelectedRemoteResources();
        BranchTagWizard wizard = new BranchTagWizard(resources);
        SizePersistedWizardDialog dialog = new SizePersistedWizardDialog(this.getShell(), (IWizard)wizard, "BranchTag");
        if (dialog.open() == 0) {
            SVNUrl[] sourceUrls = wizard.getUrls();
            SVNUrl destinationUrl = wizard.getToUrl();
            String message = wizard.getComment();
            SVNRevision revision = wizard.getRevision();
            boolean makeParents = wizard.isMakeParents();
            ISVNClientAdapter client = null;
            try {
                ISVNRepositoryLocation repository = SVNProviderPlugin.getPlugin().getRepository(sourceUrls[0].toString());
                if (repository != null) {
                    client = repository.getSVNClient();
                }
                if (client == null) {
                    client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                }
                RepositoryBranchTagOperation branchTagOperation = new RepositoryBranchTagOperation(this.getTargetPart(), client, sourceUrls, destinationUrl, revision, message, makeParents);
                branchTagOperation.setMultipleTransactions(wizard.isSameStructure());
                branchTagOperation.run();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("BranchTagDialog.title"), (String)e.getMessage());
            }
        }
    }

    @Override
    protected boolean isEnabled() throws TeamException {
        ISVNRepositoryLocation repository = null;
        ISVNRemoteResource[] resources = this.getSelectedRemoteResources();
        int i = 0;
        while (i < resources.length) {
            if (repository != null && !resources[i].getRepository().equals(repository)) {
                return false;
            }
            repository = resources[i].getRepository();
            ++i;
        }
        return true;
    }

    @Override
    protected String getImageId() {
        return "Menu Branch/Tag";
    }
}

