/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.File2Resource;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.operations.RevertOperation;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardRevertPage;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class RevertAction
extends WorkbenchWindowAction {
    private String url;
    private IResource[] resourcesToRevert;
    private HashMap statusMap;
    private SvnWizardRevertPage revertPage;
    private IResource[] selectedResources;
    private boolean canRunAsJob = true;
    private boolean showNothingToRevertMessage = true;
    private boolean includesExternals;
    private boolean resourcesHidden;

    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        block5: {
            this.statusMap = new HashMap();
            this.includesExternals = false;
            this.resourcesHidden = false;
            IResource[] resources = this.getSelectedResources();
            try {
                IResource[] modifiedResources = this.getModifiedResources(resources, (IProgressMonitor)new NullProgressMonitor());
                if (!this.confirmRevert(modifiedResources)) {
                    return;
                }
                RevertOperation revertOperation = null;
                if (this.revertPage != null && !this.revertPage.isResourceRemoved() && !this.includesExternals) {
                    revertOperation = new RevertOperation(this.getTargetPart(), resources);
                    revertOperation.setRecurse(true);
                    revertOperation.setResourcesToRevert(this.resourcesToRevert);
                } else {
                    revertOperation = new RevertOperation(this.getTargetPart(), this.resourcesToRevert);
                }
                revertOperation.setCanRunAsJob(this.canRunAsJob);
                revertOperation.run();
            }
            catch (SVNException e) {
                if (e.operationInterrupted()) break block5;
                throw new InvocationTargetException(e);
            }
        }
    }

    @Override
    protected IResource[] getModifiedResources(IResource[] resources, IProgressMonitor iProgressMonitor) throws SVNException {
        boolean ignoreHiddenChanges = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("ignore_hidden_changes");
        if (resources.length == 1) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[0]);
            this.url = svnResource.getStatus().getUrlString();
            if (this.url == null || resources[0].getType() == 1) {
                this.url = Util.getParentUrl((ISVNLocalResource)svnResource);
            }
        }
        ArrayList<IFile> conflictFiles = new ArrayList<IFile>();
        ArrayList<IResource> modified = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            GetStatusCommand command = new GetStatusCommand(svnResource, true, false);
            command.run(iProgressMonitor);
            ISVNStatus[] statuses = command.getStatuses();
            int j = 0;
            while (j < statuses.length) {
                ISVNLocalResource localResource;
                IResource currentResource;
                if (statuses[j].isFileExternal() || SVNStatusKind.EXTERNAL.equals((Object)statuses[j].getTextStatus())) {
                    this.includesExternals = true;
                }
                boolean isManaged = SVNStatusUtils.isManaged((ISVNStatus)statuses[j]);
                if (!(!SVNStatusUtils.isReadyForRevert((ISVNStatus)statuses[j]) && isManaged || (currentResource = SVNWorkspaceRoot.getResourceFor((IResource)resource, (ISVNStatus)statuses[j])) == null || (localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)currentResource)).isIgnored() || !isManaged && Util.isSpecialEclipseFile((IResource)currentResource))) {
                    boolean hidden = Util.isHidden((IResource)currentResource);
                    if (ignoreHiddenChanges && hidden) {
                        this.resourcesHidden = true;
                    }
                    if (!ignoreHiddenChanges && isManaged || !hidden) {
                        modified.add(currentResource);
                        if (currentResource instanceof IContainer) {
                            this.statusMap.put(currentResource, statuses[j].getPropStatus());
                        } else {
                            this.statusMap.put(currentResource, statuses[j].getTextStatus());
                            if (SVNStatusUtils.isTextConflicted((ISVNStatus)statuses[j])) {
                                IFile conflictWorkingFile;
                                IFile conflictOldFile;
                                IFile conflictNewFile = (IFile)File2Resource.getResource((File)statuses[j].getConflictNew());
                                if (conflictNewFile != null) {
                                    conflictFiles.add(conflictNewFile);
                                }
                                if ((conflictOldFile = (IFile)File2Resource.getResource((File)statuses[j].getConflictOld())) != null) {
                                    conflictFiles.add(conflictOldFile);
                                }
                                if ((conflictWorkingFile = (IFile)File2Resource.getResource((File)statuses[j].getConflictWorking())) != null) {
                                    conflictFiles.add(conflictWorkingFile);
                                }
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        for (IFile conflictFile : conflictFiles) {
            modified.remove(conflictFile);
            this.statusMap.remove(conflictFile);
        }
        return modified.toArray(new IResource[modified.size()]);
    }

    protected boolean confirmRevert(IResource[] modifiedResources) {
        if (modifiedResources.length == 0) {
            if (this.showNothingToRevertMessage) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind("RevertAction.0"), (String)Policy.bind("RevertAction.1"));
            }
            return false;
        }
        this.revertPage = new SvnWizardRevertPage(modifiedResources, this.url, this.statusMap, false);
        this.revertPage.setResourceRemoved(this.resourcesHidden);
        SvnWizard wizard = new SvnWizard(this.revertPage);
        SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
        boolean revert = dialog.open() == 0;
        this.url = null;
        this.resourcesToRevert = this.revertPage.getSelectedResources();
        return revert;
    }

    @Override
    protected String getErrorTitle() {
        return Policy.bind("RevertAction.error");
    }

    @Override
    protected boolean isEnabledForManagedResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForUnmanagedResources() {
        return SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_remove_unadded_resources_on_replace");
    }

    @Override
    protected boolean isEnabledForInaccessibleResources() {
        return true;
    }

    @Override
    protected String getImageId() {
        return "Menu Revert";
    }

    @Override
    protected IResource[] getSelectedResources() {
        if (this.selectedResources == null) {
            return super.getSelectedResources();
        }
        return this.selectedResources;
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }

    public void setShowNothingToRevertMessage(boolean showNothingToRevertMessage) {
        this.showNothingToRevertMessage = showNothingToRevertMessage;
    }
}

