/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.IPropertyProvider;
import org.tigris.subversion.subclipse.ui.compare.PropertyComparePropertyNode;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class PropertyCompareLocalResourceNode
implements IStructureComparator,
ITypedElement,
IStreamContentAccessor,
IPropertyProvider {
    private IResource resource;
    private boolean recursive;
    private ISVNProperty[] properties;
    private Object[] children;

    public PropertyCompareLocalResourceNode(IResource resource, boolean recursive, ISVNProperty[] properties) {
        this.resource = resource;
        this.recursive = recursive;
        this.properties = properties;
    }

    public InputStream getContents() throws CoreException {
        return null;
    }

    public String getName() {
        return this.resource.getName();
    }

    public Image getImage() {
        return CompareUI.getImage((IAdaptable)this.resource);
    }

    public String getType() {
        return "FOLDER";
    }

    public Object[] getChildren() {
        if (this.children == null) {
            ArrayList<Object> childList = new ArrayList<Object>();
            ISVNProperty[] iSVNPropertyArray = this.properties;
            int n = this.properties.length;
            int n2 = 0;
            while (n2 < n) {
                ISVNProperty property = iSVNPropertyArray[n2];
                if (property.getFile().getAbsolutePath().equals(this.resource.getLocation().toOSString())) {
                    childList.add(new PropertyComparePropertyNode(property));
                }
                ++n2;
            }
            if (this.recursive && this.resource instanceof IContainer) {
                try {
                    IResource[] childResources;
                    IResource[] iResourceArray = childResources = ((IContainer)this.resource).members();
                    int n3 = childResources.length;
                    n = 0;
                    while (n < n3) {
                        IResource childResource = iResourceArray[n];
                        PropertyCompareLocalResourceNode childNode = new PropertyCompareLocalResourceNode(childResource, true, this.properties);
                        childList.add(childNode);
                        ++n;
                    }
                }
                catch (CoreException e) {
                    SVNUIPlugin.log(e);
                }
            }
            this.children = new Object[childList.size()];
            childList.toArray(this.children);
        }
        return this.children;
    }

    public boolean equals(Object other) {
        if (!this.recursive) {
            return true;
        }
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void getProperties(boolean recursive) {
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
        ISVNClientAdapter svnClient = null;
        try {
            try {
                svnClient = svnResource.getRepository().getSVNClient();
                this.properties = svnClient.getProperties(this.resource.getLocation().toFile(), recursive);
            }
            catch (Exception e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
                svnResource.getRepository().returnSVNClient(svnClient);
            }
        }
        finally {
            svnResource.getRepository().returnSVNClient(svnClient);
        }
    }

    @Override
    public String getLabel() {
        return String.valueOf(Policy.bind("PropertyCompareLocalResourceNode.0")) + this.resource.getName();
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public IResource getResource() {
        return this.resource;
    }
}

