/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;

public class SVNLocalResourceSummaryNode
extends BufferedResourceNode {
    private final ISVNLocalResource svnResource;
    private ArrayList fChildren = null;
    private SVNDiffSummary[] diffSummary;
    private String rootLocation;

    public SVNLocalResourceSummaryNode(ISVNLocalResource svnResource, SVNDiffSummary[] diffSummary, String rootLocation) {
        super(svnResource.getIResource());
        this.svnResource = svnResource;
        this.diffSummary = diffSummary;
        this.rootLocation = rootLocation;
    }

    protected InputStream createStream() throws CoreException {
        return ((IFile)this.getResource()).getContents();
    }

    public ISVNLocalResource getLocalResource() {
        return this.svnResource;
    }

    public String getName() {
        String name = null;
        try {
            ISVNRemoteResource baseResource = this.svnResource.getBaseResource();
            if (baseResource != null) {
                name = baseResource.getName();
            }
        }
        catch (SVNException sVNException) {}
        if (name != null) {
            return name;
        }
        return super.getName();
    }

    public void setContent(byte[] contents) {
        if (contents == null) {
            contents = new byte[]{};
        }
        final ByteArrayInputStream is = new ByteArrayInputStream(contents);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IFile file = (IFile)SVNLocalResourceSummaryNode.this.getResource();
                    if (!file.exists()) {
                        file.create(is, false, monitor);
                    } else {
                        file.setContents(is, false, true, monitor);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            SVNUIPlugin.openError(SVNUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), Policy.bind("TeamFile.saveChanges", this.svnResource.getName()), null, e);
        }
        catch (InterruptedException interruptedException) {}
        this.fireContentChanged();
    }

    public Object[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
            if (this.svnResource instanceof ISVNLocalFolder) {
                try {
                    ISVNLocalResource[] members = (ISVNLocalResource[])((ISVNLocalFolder)this.svnResource).members(null, 59);
                    int i = 0;
                    while (i < members.length) {
                        IStructureComparator child;
                        if (this.include(members[i]) && (child = this.createChild(members[i])) != null) {
                            this.fChildren.add(child);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return this.fChildren.toArray();
    }

    protected IStructureComparator createChild(ISVNLocalResource child) {
        return new SVNLocalResourceSummaryNode(child, this.diffSummary, this.rootLocation);
    }

    private boolean include(ISVNLocalResource member) {
        String relativeLocation = member.getResource().getLocation().toString().substring(this.rootLocation.length() + 1);
        int i = 0;
        while (i < this.diffSummary.length) {
            if (this.diffSummary[i].getPath().equals(relativeLocation)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

