/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.service.prefs.BackingStoreException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Messages;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.WorkspaceAction;
import org.tigris.subversion.subclipse.ui.conflicts.BuiltInConflictsCompareInput;
import org.tigris.subversion.subclipse.ui.conflicts.MergeFileAssociation;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.utils.Command;

public class BuiltInEditConflictsAction
extends WorkspaceAction {
    private File conflictNewFile;
    private File conflictOldFile;
    private File conflictWorkingFile;
    private File mergedFile;
    private BuiltInConflictsCompareInput builtInConflictsCompareInput;
    private String fileName;
    private SVNConflictDescriptor conflictDescriptor;

    public BuiltInEditConflictsAction(File conflictNewFile, File conflictOldFile, File conflictWorkingFile, File mergedFile, String fileName, SVNConflictDescriptor conflictDescriptor) {
        this.conflictNewFile = conflictNewFile;
        this.conflictOldFile = conflictOldFile;
        this.conflictWorkingFile = conflictWorkingFile;
        this.mergedFile = mergedFile;
        this.fileName = fileName;
        this.conflictDescriptor = conflictDescriptor;
    }

    private void editConflictsInternal() throws InvocationTargetException, InterruptedException {
        CompareConfiguration cc = new CompareConfiguration();
        cc.setLeftEditable(true);
        this.builtInConflictsCompareInput = new BuiltInConflictsCompareInput(cc, this.conflictDescriptor);
        this.builtInConflictsCompareInput.setResources(this.conflictOldFile, this.conflictWorkingFile, this.conflictNewFile, this.mergedFile, this.fileName);
        CompareUI.openCompareEditorOnPage((CompareEditorInput)this.builtInConflictsCompareInput, (IWorkbenchPage)this.getTargetPage());
    }

    private void editConflictsExternal(String mergeProgramLocation, String mergeProgramParameters) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            this.builtInConflictsCompareInput = new BuiltInConflictsCompareInput(new CompareConfiguration(), this.conflictDescriptor);
            if (mergeProgramLocation.equals("")) {
                throw new SVNException(Messages.BuiltInEditConflictsAction_0);
            }
            File mergeProgramFile = new File(mergeProgramLocation);
            if (!mergeProgramFile.exists()) {
                throw new SVNException(Messages.BuiltInEditConflictsAction_1);
            }
            Command command = new Command(mergeProgramLocation);
            String[] parameters = mergeProgramParameters.split(" ");
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = this.replaceParameter(parameters[i], "${theirs}", this.conflictNewFile.getAbsolutePath());
                parameters[i] = this.replaceParameter(parameters[i], "${yours}", this.conflictWorkingFile.getAbsolutePath());
                parameters[i] = this.replaceParameter(parameters[i], "${base}", this.conflictOldFile.getAbsolutePath());
                parameters[i] = this.replaceParameter(parameters[i], "${merged}", this.mergedFile.getAbsolutePath());
                ++i;
            }
            command.setParameters(parameters);
            command.exec();
            command.waitFor();
            this.builtInConflictsCompareInput.handleExternalDispose();
        }
        catch (IOException e) {
            throw new SVNException(String.valueOf(Messages.BuiltInEditConflictsAction_2) + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        try {
            MergeFileAssociation mergeFileAssociation = null;
            try {
                mergeFileAssociation = SVNUIPlugin.getPlugin().getMergeFileAssociation(this.fileName);
            }
            catch (BackingStoreException backingStoreException) {
                mergeFileAssociation = new MergeFileAssociation();
            }
            if (mergeFileAssociation.getType() == 0) {
                this.editConflictsInternal();
            } else if (mergeFileAssociation.getType() == 1) {
                IPreferenceStore preferenceStore = SVNUIPlugin.getPlugin().getPreferenceStore();
                String mergeProgramLocation = preferenceStore.getString("pref_merge_program_location");
                String mergeProgramParameters = preferenceStore.getString("pref_merge_program_parameters");
                this.editConflictsExternal(mergeProgramLocation, mergeProgramParameters);
            } else {
                this.editConflictsExternal(mergeFileAssociation.getMergeProgram(), mergeFileAssociation.getParameters());
            }
        }
        catch (Exception e) {
            if (this.builtInConflictsCompareInput == null) {
                this.builtInConflictsCompareInput = new BuiltInConflictsCompareInput(new CompareConfiguration(), this.conflictDescriptor);
            }
            this.builtInConflictsCompareInput.setFinished(true);
            throw new InvocationTargetException(e);
        }
    }

    @Override
    protected String getErrorTitle() {
        return Messages.BuiltInEditConflictsAction_3;
    }

    @Override
    protected boolean isEnabledForSVNResource(ISVNLocalResource svnResource) {
        try {
            return this.conflictWorkingFile != null && svnResource.getStatusFromCache().isTextConflicted();
        }
        catch (SVNException sVNException) {
            return false;
        }
    }

    @Override
    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    private String replaceParameter(String input, String pattern, String value) {
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = input.indexOf(pattern, startIdx)) >= 0) {
            result.append(input.substring(startIdx, idxOld));
            result.append(value);
            startIdx = idxOld + pattern.length();
        }
        result.append(input.substring(startIdx));
        return result.toString();
    }

    @Override
    protected String getImageId() {
        return "Menu Edit Conflicts";
    }

    public BuiltInConflictsCompareInput getBuiltInConflictsCompareInput() {
        return this.builtInConflictsCompareInput;
    }
}

