/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.decorator;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.IDecoration;
import org.tigris.subversion.subclipse.ui.decorator.IDecoratorComponent;

public class SVNDecoratorConfiguration {
    public static final String RESOURCE_NAME = "name";
    public static final String RESOURCE_REVISION = "revision";
    public static final String RESOURCE_AUTHOR = "author";
    public static final String RESOURCE_DATE = "date";
    public static final String RESOURCE_URL = "url";
    public static final String RESOURCE_URL_SHORT = "url_short";
    public static final String RESOURCE_LABEL = "label";
    public static final String DIRTY_FLAG = "dirty_flag";
    public static final String ADDED_FLAG = "added_flag";
    public static final String EXTERNAL_FLAG = "external_flag";
    public static final String DEFAULT_DIRTY_FLAG = "";
    public static final String DEFAULT_ADDED_FLAG = "";
    public static final String DEFAULT_EXTERNAL_FLAG = "";
    public static final String DEFAULT_FILETEXTFORMAT = "{added_flag}{dirty_flag}{name} {revision}  {date}  {author}";
    public static final String DEFAULT_FOLDERTEXTFORMAT = "{external_flag}{added_flag}{dirty_flag}{name} ";
    public static final String DEFAULT_PROJECTTEXTFORMAT = "{dirty_flag}{name} [{url_short}]";
    public static final String OUTGOING_CHANGE_FOREGROUND_COLOR = "svn_outgoing_change_foreground_color";
    public static final String OUTGOING_CHANGE_BACKGROUND_COLOR = "svn_outgoing_change_background_color";
    public static final String OUTGOING_CHANGE_FONT = "svn_outgoing_change_font";
    public static final String IGNORED_FOREGROUND_COLOR = "svn_ignored_resource_foreground_color";
    public static final String IGNORED_BACKGROUND_COLOR = "svn_ignored_resource_background_color";
    public static final String IGNORED_FONT = "svn_ignored_resource_font";

    public static void decorate(IDecoration decoration, IDecoratorComponent[][] format, Map bindings) {
        String[] prefixSuffix = SVNDecoratorConfiguration.decorate(format, bindings);
        decoration.addPrefix(prefixSuffix[0]);
        decoration.addSuffix(prefixSuffix[1]);
    }

    public static String decorate(String name, String formatString, Map bindings) {
        IDecoratorComponent[][] format = SVNDecoratorConfiguration.compileFormatString(formatString);
        String[] prefixSuffix = SVNDecoratorConfiguration.decorate(format, bindings);
        return String.valueOf(prefixSuffix[0]) + name + prefixSuffix[1];
    }

    public static IDecoratorComponent[][] compileFormatString(String format) {
        int length = format.length();
        int start = -1;
        int end = length;
        boolean isPrefix = true;
        ArrayList<IDecoratorComponent> prefix = new ArrayList<IDecoratorComponent>();
        ArrayList<IDecoratorComponent> suffix = new ArrayList<IDecoratorComponent>();
        while (start + 1 < length) {
            ConstantValueDecoratorComponent component;
            end = format.indexOf(123, start);
            if (end > -1) {
                if (start + 1 != end) {
                    component = new ConstantValueDecoratorComponent(format.substring(start + 1, end));
                    if (isPrefix) {
                        prefix.add(component);
                    } else {
                        suffix.add(component);
                    }
                }
                if ((start = format.indexOf(125, end)) > -1) {
                    String key = format.substring(end + 1, start);
                    if (key.equals(RESOURCE_NAME)) {
                        isPrefix = false;
                        continue;
                    }
                    MappedValueDecoratorComponent component2 = new MappedValueDecoratorComponent(key);
                    if (isPrefix) {
                        prefix.add(component2);
                        continue;
                    }
                    suffix.add(component2);
                    continue;
                }
                component = new ConstantValueDecoratorComponent(format.substring(end));
                if (isPrefix) {
                    prefix.add(component);
                    break;
                }
                suffix.add(component);
                break;
            }
            component = new ConstantValueDecoratorComponent(format.substring(start + 1));
            if (isPrefix) {
                prefix.add(component);
                break;
            }
            suffix.add(component);
            break;
        }
        return new IDecoratorComponent[][]{prefix.toArray(new IDecoratorComponent[prefix.size()]), suffix.toArray(new IDecoratorComponent[suffix.size()])};
    }

    public static String[] decorate(IDecoratorComponent[][] format, Map bindings) {
        String value;
        StringBuffer prefix = new StringBuffer(80);
        StringBuffer suffix = new StringBuffer(80);
        int iPrefix = 0;
        while (iPrefix < format[0].length) {
            value = format[0][iPrefix].getValue(bindings);
            if (value != null) {
                prefix.append(value);
            }
            ++iPrefix;
        }
        int iSuffix = 0;
        while (iSuffix < format[1].length) {
            value = format[1][iSuffix].getValue(bindings);
            if (value != null) {
                suffix.append(value);
            }
            ++iSuffix;
        }
        return new String[]{prefix.toString(), suffix.toString()};
    }

    private static class ConstantValueDecoratorComponent
    implements IDecoratorComponent {
        private final String value;

        public ConstantValueDecoratorComponent(String value) {
            this.value = value;
        }

        @Override
        public String getValue(Map bindings) {
            return this.value;
        }

        public String toString() {
            return String.valueOf('\"') + this.value + '\"';
        }
    }

    private static class MappedValueDecoratorComponent
    implements IDecoratorComponent {
        private final String key;

        public MappedValueDecoratorComponent(String key) {
            this.key = key;
        }

        @Override
        public String getValue(Map bindings) {
            return (String)bindings.get(this.key);
        }

        public String toString() {
            return String.valueOf('{') + this.key + '}';
        }
    }
}

