/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.SvnDialog;

public class GenerateChangeLogDialog
extends SvnDialog {
    private List<LogEntry> logEntries;
    private Button svnLogButton;
    private Button svnLogAndPathsButton;
    private Button gnuButton;
    private Button clipboardButton;
    private Button fileButton;
    private Text fileText;
    private Button browseButton;
    private Text previewText;
    private Button okButton;
    private IDialogSettings settings;
    private int lastFormat;
    private int lastOutput;
    private String changeLogPreview;
    private Exception exception;
    public static final int CLIPBOARD = 0;
    public static final int FILESYSTEM = 1;
    private static final String LAST_OUTPUT = "GenerateChangeLogDialog.lastOutput";
    public static final int SVN_LOG = 0;
    public static final int SVN_LOG_WITH_PATHS = 1;
    public static final int GNU = 2;
    private static final String LAST_FORMAT = "GenerateChangeLogDialog.lastFormat";

    public GenerateChangeLogDialog(Shell shell, List<LogEntry> logEntries) {
        super(shell, "GenerateChangeLogDialog");
        this.logEntries = logEntries;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        try {
            this.lastFormat = this.settings.getInt(LAST_FORMAT);
        }
        catch (Exception exception) {}
        try {
            this.lastOutput = this.settings.getInt(LAST_OUTPUT);
        }
        catch (Exception exception) {}
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("GenerateChangeLogDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group formatGroup = new Group(composite, 0);
        formatGroup.setText(Policy.bind("GenerateChangeLogDialog.outputFormat"));
        GridLayout formatLayout = new GridLayout();
        formatLayout.numColumns = 1;
        formatGroup.setLayout((Layout)formatLayout);
        GridData data = new GridData(768);
        formatGroup.setLayoutData((Object)data);
        this.svnLogButton = new Button((Composite)formatGroup, 16);
        this.svnLogButton.setText(Policy.bind("GenerateChangeLogDialog.svnLog"));
        this.svnLogAndPathsButton = new Button((Composite)formatGroup, 16);
        this.svnLogAndPathsButton.setText(Policy.bind("GenerateChangeLogDialog.svnLogAndPaths"));
        this.gnuButton = new Button((Composite)formatGroup, 16);
        this.gnuButton.setText(Policy.bind("GenerateChangeLogDialog.gnu"));
        Group outputGroup = new Group(composite, 0);
        outputGroup.setText(Policy.bind("GenerateChangeLogDialog.saveTo"));
        GridLayout outputLayout = new GridLayout();
        outputLayout.numColumns = 2;
        outputGroup.setLayout((Layout)outputLayout);
        data = new GridData(768);
        outputGroup.setLayoutData((Object)data);
        this.clipboardButton = new Button((Composite)outputGroup, 16);
        this.clipboardButton.setText(Policy.bind("GenerateChangeLogDialog.clipboard"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.clipboardButton.setLayoutData((Object)data);
        this.fileButton = new Button((Composite)outputGroup, 16);
        this.fileButton.setText(Policy.bind("GenerateChangeLogDialog.fileSystem"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.fileButton.setLayoutData((Object)data);
        this.fileText = new Text((Composite)outputGroup, 2048);
        data = new GridData();
        data.widthHint = 450;
        this.fileText.setLayoutData((Object)data);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerateChangeLogDialog.this.okButton.setEnabled(GenerateChangeLogDialog.this.canFinish());
            }
        });
        this.browseButton = new Button((Composite)outputGroup, 0);
        this.browseButton.setText(Policy.bind("GenerateSVNDiff.Browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog d = new FileDialog(GenerateChangeLogDialog.this.getShell(), 40960);
                d.setText(Policy.bind("GenerateChangeLogDialog.saveAs"));
                d.setFileName(Policy.bind("GenerateChangeLogDialog.changeLogTxt"));
                String file = d.open();
                if (file != null) {
                    Path path = new Path(file);
                    GenerateChangeLogDialog.this.fileText.setText(path.toOSString());
                }
            }
        });
        if (this.lastOutput == 1) {
            this.fileText.setFocus();
        } else {
            this.fileText.setEnabled(false);
            this.browseButton.setEnabled(false);
        }
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == GenerateChangeLogDialog.this.clipboardButton || e.getSource() == GenerateChangeLogDialog.this.fileButton) {
                    if (GenerateChangeLogDialog.this.fileButton.getSelection()) {
                        GenerateChangeLogDialog.this.settings.put(GenerateChangeLogDialog.LAST_OUTPUT, 1);
                    } else {
                        GenerateChangeLogDialog.this.settings.put(GenerateChangeLogDialog.LAST_OUTPUT, 0);
                    }
                    GenerateChangeLogDialog.this.fileText.setEnabled(GenerateChangeLogDialog.this.fileButton.getSelection());
                    if (e.getSource() == GenerateChangeLogDialog.this.fileButton && GenerateChangeLogDialog.this.fileButton.getSelection()) {
                        GenerateChangeLogDialog.this.fileText.setFocus();
                    }
                    GenerateChangeLogDialog.this.browseButton.setEnabled(GenerateChangeLogDialog.this.fileButton.getSelection());
                    GenerateChangeLogDialog.this.okButton.setEnabled(GenerateChangeLogDialog.this.canFinish());
                } else {
                    if (GenerateChangeLogDialog.this.svnLogButton.getSelection()) {
                        GenerateChangeLogDialog.this.settings.put(GenerateChangeLogDialog.LAST_FORMAT, 0);
                    } else if (GenerateChangeLogDialog.this.svnLogAndPathsButton.getSelection()) {
                        GenerateChangeLogDialog.this.settings.put(GenerateChangeLogDialog.LAST_FORMAT, 1);
                    } else {
                        GenerateChangeLogDialog.this.settings.put(GenerateChangeLogDialog.LAST_FORMAT, 2);
                    }
                    GenerateChangeLogDialog.this.generateChangeLog(true);
                }
            }
        };
        this.svnLogButton.addSelectionListener((SelectionListener)selectionListener);
        this.svnLogAndPathsButton.addSelectionListener((SelectionListener)selectionListener);
        this.gnuButton.addSelectionListener((SelectionListener)selectionListener);
        this.clipboardButton.addSelectionListener((SelectionListener)selectionListener);
        this.gnuButton.addSelectionListener((SelectionListener)selectionListener);
        switch (this.lastFormat) {
            case 0: {
                this.svnLogButton.setSelection(true);
                break;
            }
            case 1: {
                this.svnLogAndPathsButton.setSelection(true);
                break;
            }
            case 2: {
                this.gnuButton.setSelection(true);
                break;
            }
            default: {
                this.svnLogButton.setSelection(true);
            }
        }
        switch (this.lastOutput) {
            case 0: {
                this.clipboardButton.setSelection(true);
                break;
            }
            case 1: {
                this.fileButton.setSelection(true);
                break;
            }
            default: {
                this.clipboardButton.setSelection(true);
            }
        }
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.fileText.addFocusListener((FocusListener)focusListener);
        Group previewGroup = new Group(composite, 0);
        previewGroup.setText(Policy.bind("GenerateChangeLogDialog.3"));
        GridLayout previewLayout = new GridLayout();
        previewLayout.numColumns = 1;
        previewGroup.setLayout((Layout)previewLayout);
        data = new GridData(1808);
        previewGroup.setLayoutData((Object)data);
        this.previewText = new Text((Composite)previewGroup, 2826);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 200;
        data.widthHint = 500;
        data.grabExcessHorizontalSpace = true;
        this.previewText.setLayoutData((Object)data);
        this.generateChangeLog(true);
        return composite;
    }

    @Override
    protected void okPressed() {
        File file;
        if (this.fileButton.getSelection() && (file = new File(this.fileText.getText().trim())).exists()) {
            String title = Policy.bind("GenerateSVNDiff.overwriteTitle");
            String msg = Policy.bind("GenerateSVNDiff.overwriteMsg");
            MessageDialog messageDialog = new MessageDialog(Display.getDefault().getActiveShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            if (messageDialog.open() != 0) {
                return;
            }
        }
        if (!this.generateChangeLog(false)) {
            return;
        }
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            if (this.lastOutput == 1) {
                this.okButton.setEnabled(false);
            }
        }
        return button;
    }

    private boolean generateChangeLog(final boolean preview) {
        this.exception = null;
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (!preview && GenerateChangeLogDialog.this.fileButton.getSelection()) {
                        File file = new File(GenerateChangeLogDialog.this.fileText.getText().trim());
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                        for (LogEntry logEntry : GenerateChangeLogDialog.this.logEntries) {
                            if (GenerateChangeLogDialog.this.gnuButton.getSelection()) {
                                writer.write(logEntry.getGnuLog());
                                continue;
                            }
                            writer.write(logEntry.getChangeLog(GenerateChangeLogDialog.this.svnLogAndPathsButton.getSelection()));
                        }
                        writer.close();
                    } else {
                        StringBuffer changeLog = new StringBuffer();
                        for (LogEntry logEntry : GenerateChangeLogDialog.this.logEntries) {
                            if (GenerateChangeLogDialog.this.gnuButton.getSelection()) {
                                changeLog.append(logEntry.getGnuLog());
                                continue;
                            }
                            changeLog.append(logEntry.getChangeLog(GenerateChangeLogDialog.this.svnLogAndPathsButton.getSelection()));
                        }
                        if (preview) {
                            GenerateChangeLogDialog.this.changeLogPreview = changeLog.toString().trim();
                        } else {
                            TextTransfer plainTextTransfer = TextTransfer.getInstance();
                            Clipboard clipboard = new Clipboard(Display.getDefault());
                            clipboard.setContents((Object[])new String[]{changeLog.toString().trim()}, new Transfer[]{plainTextTransfer});
                            clipboard.dispose();
                        }
                    }
                }
                catch (Exception e) {
                    GenerateChangeLogDialog.this.exception = e;
                }
            }
        });
        if (this.exception != null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Policy.bind("HistoryView.generateChangeLog"), (String)this.exception.getMessage());
            return false;
        }
        if (preview && this.changeLogPreview != null) {
            this.previewText.setText(this.changeLogPreview);
        }
        return true;
    }

    private boolean canFinish() {
        if (this.fileButton.getSelection()) {
            if (this.fileText.getText().trim().length() == 0) {
                return false;
            }
            File file = new File(this.fileText.getText().trim());
            return this.isValidFile(file);
        }
        return true;
    }

    private boolean isValidFile(File file) {
        if (!file.isAbsolute()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (!parent.exists()) {
            return false;
        }
        return parent.isDirectory();
    }
}

