/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.util.Date;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.SubclipseTrayDialog;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class RemoteResourcePropertiesDialog
extends SubclipseTrayDialog {
    private ISVNRemoteResource remoteResource;
    private ISVNInfo svnInfo;
    private ISVNProperty[] properties;
    private String errorMessage;
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(75, 75, true), new ColumnWeightData(200, 200, true)};
    private String[] columnHeaders = new String[]{Policy.bind("RemoteResourcePropertiesDialog.property"), Policy.bind("RemoteResourcePropertiesDialog.value")};

    public RemoteResourcePropertiesDialog(Shell parentShell, ISVNRemoteResource remoteResource) {
        super(parentShell);
        this.setShellStyle(112);
        this.remoteResource = remoteResource;
    }

    protected Control createDialogArea(Composite parent) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ISVNClientAdapter client = null;
                try {
                    try {
                        client = SVNProviderPlugin.getPlugin().getSVNClientManager().getSVNClient();
                        SVNProviderPlugin.disableConsoleLogging();
                        RemoteResourcePropertiesDialog.this.svnInfo = client.getInfo(RemoteResourcePropertiesDialog.this.remoteResource.getUrl());
                        RemoteResourcePropertiesDialog.this.properties = client.getProperties(RemoteResourcePropertiesDialog.this.remoteResource.getUrl(), SVNRevision.HEAD, SVNRevision.HEAD, false);
                        SVNProviderPlugin.enableConsoleLogging();
                    }
                    catch (Exception e) {
                        RemoteResourcePropertiesDialog.this.errorMessage = e.getMessage();
                        SVNProviderPlugin.enableConsoleLogging();
                        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                    }
                }
                finally {
                    SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                }
            }
        });
        this.getShell().setText(Policy.bind("RemoteResourcePropertiesDialog.title"));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 5;
        gridLayout.marginWidth = 10;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.svnInfo == null) {
            Text errorText = new Text(composite, 584);
            GridData data = new GridData(4, 4, true, true, 2, 1);
            data.widthHint = 600;
            data.heightHint = 100;
            errorText.setLayoutData((Object)data);
            errorText.setEditable(false);
            errorText.setText(this.errorMessage);
            errorText.setBackground(composite.getBackground());
            return composite;
        }
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.url"));
        Text urlText = new Text(composite, 8);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 600;
        urlText.setLayoutData((Object)data);
        urlText.setEditable(false);
        urlText.setText(this.remoteResource.getUrl().toString());
        urlText.setBackground(composite.getBackground());
        Label authorLabel = new Label(composite, 0);
        authorLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.author"));
        Text authorText = new Text(composite, 8);
        authorText.setLayoutData((Object)new GridData(4, 4, true, false));
        authorText.setEditable(false);
        if (this.svnInfo.getLastCommitAuthor() != null) {
            authorText.setText(this.svnInfo.getLastCommitAuthor());
        }
        authorText.setBackground(composite.getBackground());
        Label revisionLabel = new Label(composite, 0);
        revisionLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.revision"));
        Text revisionText = new Text(composite, 8);
        revisionText.setLayoutData((Object)new GridData(4, 4, true, false));
        revisionText.setEditable(false);
        if (this.svnInfo.getLastChangedRevision() != null) {
            revisionText.setText(this.svnInfo.getLastChangedRevision().toString());
        }
        revisionText.setBackground(composite.getBackground());
        Label dateLabel = new Label(composite, 0);
        dateLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.date"));
        Text dateText = new Text(composite, 8);
        dateText.setLayoutData((Object)new GridData(4, 4, true, false));
        dateText.setEditable(false);
        if (this.svnInfo.getLastChangedDate() != null) {
            dateText.setText(this.svnInfo.getLastChangedDate().toString());
        }
        dateText.setBackground(composite.getBackground());
        if (this.remoteResource instanceof ISVNRemoteFile) {
            String lockOwner = null;
            try {
                lockOwner = this.svnInfo.getLockOwner();
            }
            catch (Exception exception) {}
            if (lockOwner != null) {
                Label lockOwnerLabel = new Label(composite, 0);
                lockOwnerLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.lockOwner"));
                Text lockOwnerText = new Text(composite, 8);
                data = new GridData(4, 4, true, false);
                data.widthHint = 600;
                lockOwnerText.setLayoutData((Object)data);
                lockOwnerText.setEditable(false);
                lockOwnerText.setText(this.svnInfo.getLockOwner());
                lockOwnerText.setBackground(composite.getBackground());
            }
            Date lockCreationDate = null;
            try {
                lockCreationDate = this.svnInfo.getLockCreationDate();
            }
            catch (Exception exception) {}
            if (lockCreationDate != null) {
                Label lockCreatedLabel = new Label(composite, 0);
                lockCreatedLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.lockCreated"));
                Text lockCreatedText = new Text(composite, 8);
                data = new GridData(4, 4, true, false);
                data.widthHint = 600;
                lockCreatedText.setLayoutData((Object)data);
                lockCreatedText.setEditable(false);
                lockCreatedText.setText(this.svnInfo.getLockCreationDate().toString());
                lockCreatedText.setBackground(composite.getBackground());
            }
            String lockComment = null;
            try {
                lockComment = this.svnInfo.getLockComment();
            }
            catch (Exception exception) {}
            if (lockComment != null) {
                Label lockCommentLabel = new Label(composite, 0);
                lockCommentLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
                lockCommentLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.lockComment"));
                Text lockCommentText = new Text(composite, 584);
                GridData lockCommentTextData = new GridData(4, 4, true, false);
                lockCommentTextData.heightHint = 100;
                lockCommentTextData.widthHint = 600;
                lockCommentText.setLayoutData((Object)lockCommentTextData);
                lockCommentText.setEditable(false);
                lockCommentText.setText(this.svnInfo.getLockComment());
                lockCommentText.setBackground(composite.getBackground());
            }
        }
        SashForm sashForm = new SashForm(composite, 512);
        GridData gd_sashForm = new GridData(4, 4, true, true, 2, 1);
        gd_sashForm.heightHint = 244;
        sashForm.setLayoutData((Object)gd_sashForm);
        Table table = new Table((Composite)sashForm, 67584);
        final Text text = new Text((Composite)sashForm, 2634);
        final TableViewer viewer = new TableViewer(table);
        viewer.setUseHashlookup(true);
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < this.columnHeaders.length) {
            tableLayout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                ISVNProperty property = (ISVNProperty)selection.getFirstElement();
                text.setText(property.getValue());
            }
        });
        GridData gd_table = new GridData(4, 4, true, true, 2, 1);
        gd_table.verticalIndent = 5;
        gd_table.heightHint = 150;
        table.setLayoutData((Object)gd_table);
        viewer.setContentProvider((IContentProvider)new RemoteResourceContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new RemoteResourceLabelProvider());
        viewer.setInput((Object)this.remoteResource);
        sashForm.setWeights(new int[]{128, 113});
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.remote_resource_properties_dialog_context");
        return composite;
    }

    class RemoteResourceContentProvider
    implements IStructuredContentProvider {
        RemoteResourceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object arg0) {
            return RemoteResourcePropertiesDialog.this.properties;
        }
    }

    class RemoteResourceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        RemoteResourceLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex >= 0 && columnIndex <= 1) {
                ISVNProperty property = (ISVNProperty)element;
                switch (columnIndex) {
                    case 0: {
                        return property.getName();
                    }
                    case 1: {
                        return property.getValue();
                    }
                }
                return "";
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

