/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.dialogs.SubclipseTrayDialog;
import org.tigris.subversion.subclipse.ui.operations.ShowDifferencesAsUnifiedDiffOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ShowDifferencesAsUnifiedDiffDialog
extends SubclipseTrayDialog {
    private ISVNResource[] remoteResources;
    private IWorkbenchPart targetPart;
    private ISVNResource fromResource;
    private Text fileText;
    private Text fromUrlText;
    private Button fromHeadButton;
    private Button fromRevisionButton;
    private Text fromRevisionText;
    private Button fromLogButton;
    private Text toUrlText;
    private Button toHeadButton;
    private Button toRevisionButton;
    private Text toRevisionText;
    private Button toLogButton;
    private Button okButton;
    private boolean success;
    private String fromRevision;
    private String toRevision;

    public ShowDifferencesAsUnifiedDiffDialog(Shell parentShell, ISVNResource[] remoteResources, IWorkbenchPart targetPart) {
        super(parentShell);
        this.remoteResources = remoteResources;
        this.targetPart = targetPart;
        this.fromResource = remoteResources[0];
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("HistoryView.showDifferences"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite fileGroup = new Composite(composite, 0);
        GridLayout fileLayout = new GridLayout();
        fileLayout.numColumns = 3;
        fileGroup.setLayout((Layout)fileLayout);
        GridData data = new GridData(4, 4, true, false);
        fileGroup.setLayoutData((Object)data);
        Label fileLabel = new Label(fileGroup, 0);
        fileLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.file"));
        this.fileText = new Text(fileGroup, 2048);
        data = new GridData(16384, 0x1000000, true, false);
        data.widthHint = 300;
        this.fileText.setLayoutData((Object)data);
        Button browseButton = new Button(fileGroup, 8);
        browseButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.fileBrowse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ShowDifferencesAsUnifiedDiffDialog.this.getShell(), 8192);
                dialog.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.fileDialogText"));
                dialog.setFileName("revision.diff");
                String outFile = dialog.open();
                if (outFile != null) {
                    ShowDifferencesAsUnifiedDiffDialog.this.fileText.setText(outFile);
                }
            }
        });
        Group fromGroup = new Group(composite, 0);
        fromGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareFrom"));
        GridLayout fromLayout = new GridLayout();
        fromLayout.numColumns = 2;
        fromGroup.setLayout((Layout)fromLayout);
        data = new GridData(4, 4, true, false);
        fromGroup.setLayoutData((Object)data);
        Label fromUrlLabel = new Label((Composite)fromGroup, 0);
        fromUrlLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.url"));
        this.fromUrlText = new Text((Composite)fromGroup, 2048);
        this.fromUrlText.setEditable(false);
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 300;
        this.fromUrlText.setLayoutData((Object)data);
        this.fromUrlText.setText(this.remoteResources[0].getUrl().toString());
        Group fromRevisionGroup = new Group((Composite)fromGroup, 0);
        fromRevisionGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.revision"));
        GridLayout fromRevisionLayout = new GridLayout();
        fromRevisionLayout.numColumns = 3;
        fromRevisionGroup.setLayout((Layout)fromRevisionLayout);
        data = new GridData(4, 128, true, false, 3, 1);
        fromRevisionGroup.setLayoutData((Object)data);
        this.fromHeadButton = new Button((Composite)fromRevisionGroup, 16);
        this.fromHeadButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.fromHeadButton.setLayoutData((Object)data);
        this.fromRevisionButton = new Button((Composite)fromRevisionGroup, 16);
        this.fromRevisionButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.revision"));
        this.fromHeadButton.setSelection(true);
        this.fromRevisionText = new Text((Composite)fromRevisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.fromRevisionText.setLayoutData((Object)data);
        this.fromRevisionText.setEnabled(false);
        this.fromLogButton = new Button((Composite)fromRevisionGroup, 8);
        this.fromLogButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.showLog"));
        this.fromLogButton.setEnabled(false);
        this.fromLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowDifferencesAsUnifiedDiffDialog.this.showLog(e.getSource());
            }
        });
        Group toGroup = new Group(composite, 0);
        toGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareTo"));
        GridLayout toLayout = new GridLayout();
        toLayout.numColumns = 2;
        toGroup.setLayout((Layout)toLayout);
        data = new GridData(4, 4, true, false);
        toGroup.setLayoutData((Object)data);
        Label toUrlLabel = new Label((Composite)toGroup, 0);
        toUrlLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.url"));
        this.toUrlText = new Text((Composite)toGroup, 2048);
        this.toUrlText.setEditable(false);
        data = new GridData(4, 0x1000000, false, false);
        data.widthHint = 300;
        this.toUrlText.setLayoutData((Object)data);
        this.toUrlText.setText(this.remoteResources[1].getUrl().toString());
        Group toRevisionGroup = new Group((Composite)toGroup, 0);
        toRevisionGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.revision"));
        GridLayout toRevisionLayout = new GridLayout();
        toRevisionLayout.numColumns = 3;
        toRevisionGroup.setLayout((Layout)toRevisionLayout);
        data = new GridData(4, 4, true, false, 3, 1);
        toRevisionGroup.setLayoutData((Object)data);
        this.toHeadButton = new Button((Composite)toRevisionGroup, 16);
        this.toHeadButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.toHeadButton.setLayoutData((Object)data);
        this.toRevisionButton = new Button((Composite)toRevisionGroup, 16);
        this.toRevisionButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.revision"));
        this.toHeadButton.setSelection(true);
        this.toRevisionText = new Text((Composite)toRevisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.toRevisionText.setLayoutData((Object)data);
        this.toRevisionText.setEnabled(false);
        this.toLogButton = new Button((Composite)toRevisionGroup, 8);
        this.toLogButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.showLog"));
        this.toLogButton.setEnabled(false);
        this.toLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowDifferencesAsUnifiedDiffDialog.this.showLog(e.getSource());
            }
        });
        if (this.fromRevision != null) {
            this.fromRevisionText.setText(this.fromRevision);
            this.fromRevisionText.setEnabled(true);
            this.fromLogButton.setEnabled(true);
            this.fromRevisionButton.setSelection(true);
            this.fromHeadButton.setSelection(false);
        }
        if (this.toRevision != null) {
            this.toRevisionText.setText(this.toRevision);
            this.toRevisionText.setEnabled(true);
            this.toLogButton.setEnabled(true);
            this.toRevisionButton.setSelection(true);
            this.toHeadButton.setSelection(false);
        }
        this.fileText.setFocus();
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ShowDifferencesAsUnifiedDiffDialog.this.setOkButtonStatus();
            }
        };
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionText.setEnabled(ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionButton.getSelection());
                ShowDifferencesAsUnifiedDiffDialog.this.fromLogButton.setEnabled(ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionButton.getSelection());
                ShowDifferencesAsUnifiedDiffDialog.this.toRevisionText.setEnabled(ShowDifferencesAsUnifiedDiffDialog.this.toRevisionButton.getSelection());
                ShowDifferencesAsUnifiedDiffDialog.this.toLogButton.setEnabled(ShowDifferencesAsUnifiedDiffDialog.this.toRevisionButton.getSelection());
                ShowDifferencesAsUnifiedDiffDialog.this.setOkButtonStatus();
                if (e.getSource() == ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionButton && ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionButton.getSelection()) {
                    ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionText.selectAll();
                    ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionText.setFocus();
                }
                if (e.getSource() == ShowDifferencesAsUnifiedDiffDialog.this.toRevisionButton && ShowDifferencesAsUnifiedDiffDialog.this.toRevisionButton.getSelection()) {
                    ShowDifferencesAsUnifiedDiffDialog.this.toRevisionText.selectAll();
                    ShowDifferencesAsUnifiedDiffDialog.this.toRevisionText.setFocus();
                }
            }
        };
        this.fileText.addModifyListener(modifyListener);
        this.fromRevisionText.addModifyListener(modifyListener);
        this.toRevisionText.addModifyListener(modifyListener);
        this.fromHeadButton.addSelectionListener((SelectionListener)selectionListener);
        this.fromRevisionButton.addSelectionListener((SelectionListener)selectionListener);
        this.toHeadButton.addSelectionListener((SelectionListener)selectionListener);
        this.toRevisionButton.addSelectionListener((SelectionListener)selectionListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.show_unified_diff_dialog_context");
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button toggleFromToButton = this.createButton(parent, 2, Policy.bind("ShowDifferencesAsUnifiedDiffDialog.swap"), false);
        toggleFromToButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fromUrl = ShowDifferencesAsUnifiedDiffDialog.this.fromUrlText.getText().trim();
                boolean fromHeadRevision = ShowDifferencesAsUnifiedDiffDialog.this.fromHeadButton.getSelection();
                String fromRevision = ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionText.getText().trim();
                String toUrl = ShowDifferencesAsUnifiedDiffDialog.this.toUrlText.getText().trim();
                boolean toHeadRevision = ShowDifferencesAsUnifiedDiffDialog.this.toHeadButton.getSelection();
                String toRevision = ShowDifferencesAsUnifiedDiffDialog.this.toRevisionText.getText().trim();
                ShowDifferencesAsUnifiedDiffDialog.this.fromUrlText.setText(toUrl);
                ShowDifferencesAsUnifiedDiffDialog.this.toUrlText.setText(fromUrl);
                if (toHeadRevision) {
                    ShowDifferencesAsUnifiedDiffDialog.this.fromHeadButton.setSelection(true);
                    ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionButton.setSelection(false);
                } else {
                    ShowDifferencesAsUnifiedDiffDialog.this.fromHeadButton.setSelection(false);
                    ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionButton.setSelection(true);
                }
                if (fromHeadRevision) {
                    ShowDifferencesAsUnifiedDiffDialog.this.toHeadButton.setSelection(true);
                    ShowDifferencesAsUnifiedDiffDialog.this.toRevisionButton.setSelection(false);
                } else {
                    ShowDifferencesAsUnifiedDiffDialog.this.toHeadButton.setSelection(false);
                    ShowDifferencesAsUnifiedDiffDialog.this.toRevisionButton.setSelection(true);
                }
                ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionText.setText(toRevision);
                ShowDifferencesAsUnifiedDiffDialog.this.toRevisionText.setText(fromRevision);
                if (ShowDifferencesAsUnifiedDiffDialog.this.fromResource == ShowDifferencesAsUnifiedDiffDialog.this.remoteResources[0]) {
                    ShowDifferencesAsUnifiedDiffDialog.this.fromResource = ShowDifferencesAsUnifiedDiffDialog.this.remoteResources[1];
                } else {
                    ShowDifferencesAsUnifiedDiffDialog.this.fromResource = ShowDifferencesAsUnifiedDiffDialog.this.remoteResources[0];
                }
                ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionText.setEnabled(ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionButton.getSelection());
                ShowDifferencesAsUnifiedDiffDialog.this.toRevisionText.setEnabled(ShowDifferencesAsUnifiedDiffDialog.this.toRevisionButton.getSelection());
                ShowDifferencesAsUnifiedDiffDialog.this.setOkButtonStatus();
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setEnabled(false);
        }
        return button;
    }

    protected void okPressed() {
        this.success = true;
        final File file = new File(this.fileText.getText().trim());
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)Policy.bind("HistoryView.overwriteOutfile", file.getName()))) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    SVNRevision toRevision;
                    SVNRevision fromRevision;
                    SVNUrl fromUrl = null;
                    SVNUrl toUrl = null;
                    if (ShowDifferencesAsUnifiedDiffDialog.this.fromHeadButton.getSelection()) {
                        fromRevision = SVNRevision.HEAD;
                    } else {
                        int fromRevisionInt = Integer.parseInt(ShowDifferencesAsUnifiedDiffDialog.this.fromRevisionText.getText().trim());
                        long fromRevisionLong = fromRevisionInt;
                        fromRevision = new SVNRevision.Number(fromRevisionLong);
                    }
                    if (ShowDifferencesAsUnifiedDiffDialog.this.toHeadButton.getSelection()) {
                        toRevision = SVNRevision.HEAD;
                    } else {
                        int toRevisionInt = Integer.parseInt(ShowDifferencesAsUnifiedDiffDialog.this.toRevisionText.getText().trim());
                        long toRevisionLong = toRevisionInt;
                        toRevision = new SVNRevision.Number(toRevisionLong);
                    }
                    if (ShowDifferencesAsUnifiedDiffDialog.this.fromResource == ShowDifferencesAsUnifiedDiffDialog.this.remoteResources[0]) {
                        fromUrl = ShowDifferencesAsUnifiedDiffDialog.this.remoteResources[0].getUrl();
                        toUrl = ShowDifferencesAsUnifiedDiffDialog.this.remoteResources[1].getUrl();
                    } else {
                        fromUrl = ShowDifferencesAsUnifiedDiffDialog.this.remoteResources[1].getUrl();
                        toUrl = ShowDifferencesAsUnifiedDiffDialog.this.remoteResources[0].getUrl();
                    }
                    new ShowDifferencesAsUnifiedDiffOperation(ShowDifferencesAsUnifiedDiffDialog.this.targetPart, fromUrl, fromRevision, toUrl, toRevision, file).run();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)ShowDifferencesAsUnifiedDiffDialog.this.getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)e.getMessage());
                    ShowDifferencesAsUnifiedDiffDialog.this.success = false;
                }
            }
        });
        if (!this.success) {
            return;
        }
        super.okPressed();
    }

    private void setOkButtonStatus() {
        boolean canFinish = true;
        if (this.fileText.getText().trim().length() == 0) {
            canFinish = false;
        }
        if (this.fromRevisionButton.getSelection() && this.fromRevisionText.getText().trim().length() == 0) {
            canFinish = false;
        }
        if (this.toRevisionButton.getSelection() && this.toRevisionText.getText().trim().length() == 0) {
            canFinish = false;
        }
        this.okButton.setEnabled(canFinish);
    }

    private void showLog(Object sourceButton) {
        HistoryDialog dialog = null;
        if (sourceButton == this.fromLogButton) {
            dialog = this.fromResource instanceof ISVNRemoteResource ? (this.fromResource == this.remoteResources[0] ? new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.remoteResources[0]) : new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.remoteResources[1])) : (this.fromResource == this.remoteResources[0] ? new HistoryDialog(this.getShell(), this.remoteResources[0].getResource()) : new HistoryDialog(this.getShell(), this.remoteResources[1].getResource()));
            if (dialog.open() == 1) {
                return;
            }
            ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
            if (selectedEntries.length == 0) {
                return;
            }
            this.fromRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        } else {
            dialog = this.fromResource instanceof ISVNRemoteResource ? (this.fromResource == this.remoteResources[0] ? new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.remoteResources[1]) : new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.remoteResources[0])) : (this.fromResource == this.remoteResources[0] ? new HistoryDialog(this.getShell(), this.remoteResources[1].getResource()) : new HistoryDialog(this.getShell(), ((ISVNRemoteResource)this.remoteResources[0]).getResource()));
            if (dialog.open() == 1) {
                return;
            }
            ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
            if (selectedEntries.length == 0) {
                return;
            }
            this.toRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        }
        this.setOkButtonStatus();
    }

    public void setFromRevision(String fromRevision) {
        this.fromRevision = fromRevision;
    }

    public void setToRevision(String toRevision) {
        this.toRevision = toRevision;
    }
}

