/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.SwitchToUrlCommand;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.conflicts.SVNConflictResolver;
import org.tigris.subversion.subclipse.ui.decorator.SVNLightweightDecorator;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchOperation
extends RepositoryProviderOperation {
    private SVNRevision svnRevision;
    private HashMap<IResource, SVNUrl> urlMap = new HashMap();
    private int depth = 0;
    private boolean setDepth = false;
    private boolean ignoreExternals = false;
    private boolean force = true;
    private boolean ignoreAncestry = false;
    private boolean canRunAsJob = true;
    private ISVNConflictResolver conflictResolver;

    public SwitchOperation(IWorkbenchPart part, IResource[] resources, SVNUrl[] svnUrls, SVNRevision svnRevision) {
        super(part, resources);
        this.svnRevision = svnRevision;
        int i = 0;
        while (i < resources.length) {
            this.urlMap.put(resources[i], svnUrls[i]);
            ++i;
        }
    }

    @Override
    protected String getTaskName() {
        return Policy.bind("SwitchOperation.taskName");
    }

    @Override
    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("SwitchOperation.0", provider.getProject().getName());
    }

    @Override
    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        monitor.beginTask("Switch to Branch/Tag", resources.length);
        try {
            try {
                final ArrayList<IProject> projectList = new ArrayList<IProject>();
                int i = 0;
                while (i < resources.length) {
                    monitor.subTask("Switching " + resources[i].getName() + ". . .");
                    SVNUrl svnUrl = this.urlMap.get(resources[i]);
                    if (this.conflictResolver != null && this.conflictResolver instanceof SVNConflictResolver) {
                        ((SVNConflictResolver)this.conflictResolver).setPart(this.getPart());
                    }
                    SVNWorkspaceSubscriber.getInstance().updateRemote(resources);
                    SwitchToUrlCommand command = new SwitchToUrlCommand(provider.getSVNWorkspaceRoot(), resources[i], svnUrl, this.svnRevision);
                    command.setDepth(this.depth);
                    command.setSetDepth(this.setDepth);
                    command.setIgnoreExternals(this.ignoreExternals);
                    command.setForce(this.force);
                    command.setIgnoreAncestry(this.ignoreAncestry);
                    command.setConflictResolver(this.conflictResolver);
                    command.run(monitor);
                    monitor.worked(1);
                    if (resources[i].getProject() != null && !projectList.contains(resources[i].getProject())) {
                        projectList.add(resources[i].getProject());
                    }
                    ++i;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SVNLightweightDecorator decorator = (SVNLightweightDecorator)SVNUIPlugin.getPlugin().getWorkbench().getDecoratorManager().getBaseLabelProvider("org.tigris.subversion.subclipse.ui.decorator");
                        for (IProject project : projectList) {
                            decorator.refresh(project);
                        }
                    }
                });
            }
            catch (SVNException e) {
                if (e.operationInterrupted()) {
                    this.showCancelledMessage();
                } else {
                    this.collectStatus(e.getStatus());
                }
                monitor.done();
            }
            catch (TeamException e) {
                this.collectStatus(e.getStatus());
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected boolean canRunAsJob() {
        return this.canRunAsJob;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setIgnoreAncestry(boolean ignoreAncestry) {
        this.ignoreAncestry = ignoreAncestry;
    }

    public void setCanRunAsJob(boolean canRunAsJob) {
        this.canRunAsJob = canRunAsJob;
    }

    public void setConflictResolver(ISVNConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    @Override
    protected ISchedulingRule getSchedulingRule(SVNTeamProvider provider) {
        return null;
    }
}

