/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.repository.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.Branches;
import org.tigris.subversion.subclipse.core.history.Tags;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;

public class RemoteContentProvider
extends WorkbenchContentProvider {
    private Branches branches;
    private Tags tags;
    private boolean includeBranchesAndTags = true;
    private RemoteFolder rootFolder;
    private boolean useDeferredContentManager = true;
    private DeferredTreeContentManager manager;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof AbstractTreeViewer) {
            this.manager = new DeferredTreeContentManager((ITreeContentProvider)this, (AbstractTreeViewer)viewer);
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public boolean hasChildren(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Branches || element instanceof Tags) {
            return true;
        }
        if (element instanceof Alias) {
            return false;
        }
        if (element instanceof ISVNRepositoryLocation) {
            return true;
        }
        if (element instanceof ISVNRemoteResource) {
            return ((ISVNRemoteResource)element).isContainer();
        }
        if (this.manager != null && this.manager.isDeferredAdapter(element)) {
            return this.manager.mayHaveChildren(element);
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children;
        if (parentElement instanceof Branches) {
            return ((Branches)parentElement).getBranches();
        }
        if (parentElement instanceof Tags) {
            return ((Tags)parentElement).getTags();
        }
        if (this.useDeferredContentManager && this.manager != null && (children = this.manager.getChildren(parentElement)) != null) {
            if (parentElement instanceof ISVNRepositoryLocation && (this.rootFolder != null || this.branches != null || this.tags != null)) {
                ArrayList<Object> childrenArray = new ArrayList<Object>();
                if (this.rootFolder != null) {
                    childrenArray.add(this.rootFolder);
                }
                if (this.branches != null) {
                    childrenArray.add(this.branches);
                }
                if (this.tags != null) {
                    childrenArray.add(this.tags);
                }
                int i = 0;
                while (i < children.length) {
                    childrenArray.add(children[i]);
                    ++i;
                }
                children = new Object[childrenArray.size()];
                childrenArray.toArray(children);
            }
            return children;
        }
        return super.getChildren(parentElement);
    }

    public void setResource(IResource resource) {
        if (this.includeBranchesAndTags) {
            AliasManager tagManager = new AliasManager(resource);
            Alias[] branchAliases = tagManager.getBranches();
            Alias[] tagAliases = tagManager.getTags();
            if (branchAliases.length > 0) {
                this.branches = new Branches(branchAliases);
            }
            if (tagAliases.length > 0) {
                this.tags = new Tags(tagAliases);
            }
        }
    }

    public void setIncludeBranchesAndTags(boolean includeBranchesAndTags) {
        this.includeBranchesAndTags = includeBranchesAndTags;
    }

    public void cancelJobs(ISVNRepositoryLocation[] roots) {
        if (this.manager != null) {
            int i = 0;
            while (i < roots.length) {
                ISVNRepositoryLocation root = roots[i];
                this.cancelJobs(root);
                ++i;
            }
        }
    }

    public void cancelJobs(ISVNRepositoryLocation location) {
        if (this.manager != null) {
            this.manager.cancel((Object)location);
        }
    }

    public void setRootFolder(RemoteFolder rootFolder) {
        this.rootFolder = rootFolder;
    }

    public void setUseDeferredContentManager(boolean useDeferredContentManager) {
        this.useDeferredContentManager = useDeferredContentManager;
    }
}

