/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;

public class ShowHistorySynchronizeOperation
extends SVNSynchronizeOperation {
    private IResource resource;
    private ISVNRemoteResource remoteResource;
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;

    public ShowHistorySynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, IResource resource) {
        super(configuration, elements);
        this.resource = resource;
    }

    public ShowHistorySynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, ISVNRemoteResource remoteResource) {
        super(configuration, elements);
        this.remoteResource = remoteResource;
    }

    @Override
    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    @Override
    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ShowHistorySynchronizeOperation.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IHistoryView view = (IHistoryView)ShowHistorySynchronizeOperation.this.showView("org.eclipse.team.ui.GenericHistoryView");
                        if (view != null) {
                            if (ShowHistorySynchronizeOperation.this.resource == null) {
                                view.showHistoryFor((Object)ShowHistorySynchronizeOperation.this.remoteResource);
                            } else {
                                view.showHistoryFor((Object)ShowHistorySynchronizeOperation.this.resource);
                            }
                        }
                    }
                });
            }
        }, false, 2);
    }

    protected final void run(final IRunnableWithProgress runnable, boolean cancelable, int progressKind) throws InvocationTargetException, InterruptedException {
        final Exception[] exceptions = new Exception[1];
        final IRunnableWithProgress innerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SVNUIPlugin.getPlugin().getRepositoryManager().run(runnable, monitor);
            }
        };
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            innerRunnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException e) {
                            exceptions[0] = e;
                        }
                    }
                });
                break;
            }
            default: {
                new ProgressMonitorDialog(this.getShell()).run(true, cancelable, innerRunnable);
            }
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof InvocationTargetException) {
                throw (InvocationTargetException)exceptions[0];
            }
            throw (InterruptedException)exceptions[0];
        }
    }

    protected IViewPart showView(String viewId) {
        try {
            return this.getPart().getSite().getPage().showView(viewId);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }
}

