/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.ClosableWizardDialog;

public class SizePersistedWizardDialog
extends ClosableWizardDialog {
    private String sizeKey;
    private IDialogSettings settings;

    public SizePersistedWizardDialog(Shell parentShell, IWizard newWizard, String sizeKey) {
        super(parentShell, newWizard);
        this.sizeKey = sizeKey;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    @Override
    public void finishPressed() {
        this.saveLocation();
        super.finishPressed();
    }

    protected void okPressed() {
        this.saveLocation();
        super.okPressed();
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt(String.valueOf(this.sizeKey) + ".location.x");
            int y = this.settings.getInt(String.valueOf(this.sizeKey) + ".location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt(String.valueOf(this.sizeKey) + ".size.x");
            int y = this.settings.getInt(String.valueOf(this.sizeKey) + ".size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
    }

    protected void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put(String.valueOf(this.sizeKey) + ".location.x", x);
        this.settings.put(String.valueOf(this.sizeKey) + ".location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put(String.valueOf(this.sizeKey) + ".size.x", x);
        this.settings.put(String.valueOf(this.sizeKey) + ".size.y", y);
    }
}

