/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.DepthComboHelper;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.conflicts.SVNConflictResolver;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.util.UrlCombo;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnWizardSwitchPage
extends SvnWizardDialogPage {
    private static final int REVISION_WIDTH_HINT = 40;
    private IResource[] resources;
    private boolean showUrl;
    private UrlCombo urlCombo;
    private Composite revisionGroup;
    private Text revisionText;
    private Button logButton;
    private Button headButton;
    private Table table;
    private TableViewer viewer;
    private Combo depthCombo;
    private Button setDepthButton;
    private Button ignoreExternalsButton;
    private Button forceButton;
    private Button ignoreAncestryButton;
    private Button textConflictPromptButton;
    private Button textConflictMarkButton;
    private Button propertyConflictPromptButton;
    private Button propertyConflictMarkButton;
    private Button binaryConflictPromptButton;
    private Button binaryConflictMarkButton;
    private Button binaryConflictUserButton;
    private Button binaryConflictIncomingButton;
    private Button treeConflictPromptButton;
    private Button treeConflictMarkButton;
    private Button treeConflictUserButton;
    private Button treeConflictResolveButton;
    private SVNConflictResolver conflictResolver;
    private SVNUrl[] urls;
    private SVNRevision revision;
    private int depth;
    private boolean setDepth;
    private boolean ignoreExternals;
    private boolean force;
    private boolean ignoreAncestry;
    private String[] urlStrings;
    private String commonRoot;
    private SwitchResource[] switchResources;
    private long revisionNumber;
    private String[] columnHeaders = new String[]{Policy.bind("SwitchDialog.resources")};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(100, 100, true)};

    public SvnWizardSwitchPage(IResource[] resources, boolean showUrl) {
        this("SwitchDialogWithConflictHandling2", resources);
        this.showUrl = showUrl;
    }

    public SvnWizardSwitchPage(String name, IResource[] resources) {
        super(name, Policy.bind("SwitchDialog.title"));
        this.resources = resources;
        this.showUrl = true;
    }

    public SvnWizardSwitchPage(IResource[] resources, long revisionNumber) {
        this(resources, true);
        this.revisionNumber = revisionNumber;
    }

    @Override
    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        if (this.showUrl) {
            Label urlLabel = new Label(composite, 0);
            urlLabel.setText(Policy.bind("SwitchDialog.url"));
            this.urlCombo = new UrlCombo(composite, 0);
            this.urlCombo.init(this.resources[0].getProject().getName());
            this.urlCombo.setLayoutData(new GridData(768));
            this.commonRoot = this.getCommonRoot();
            if (this.commonRoot != null) {
                this.urlCombo.setText(this.commonRoot);
            }
            this.urlCombo.getCombo().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SvnWizardSwitchPage.this.setPageComplete(SvnWizardSwitchPage.this.canFinish());
                }
            });
            Button browseButton = new Button(composite, 8);
            browseButton.setText(Policy.bind("SwitchDialog.browse"));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseUrlDialog dialog = new ChooseUrlDialog(SvnWizardSwitchPage.this.getShell(), SvnWizardSwitchPage.this.resources[0]);
                    dialog.setIncludeBranchesAndTags(SvnWizardSwitchPage.this.resources.length == 1);
                    if (dialog.open() == 0 && dialog.getUrl() != null) {
                        SvnWizardSwitchPage.this.urlCombo.setText(dialog.getUrl());
                        SvnWizardSwitchPage.this.setPageComplete(SvnWizardSwitchPage.this.canFinish());
                    }
                }
            });
            this.revisionGroup = new Composite(composite, 0);
            GridLayout revisionLayout = new GridLayout();
            revisionLayout.numColumns = 3;
            revisionLayout.marginWidth = 0;
            revisionLayout.marginHeight = 0;
            this.revisionGroup.setLayout((Layout)revisionLayout);
            data = new GridData(768);
            data.horizontalSpan = 3;
            this.revisionGroup.setLayoutData((Object)data);
            this.headButton = new Button(this.revisionGroup, 32);
            this.headButton.setText(Policy.bind("SvnWizardSwitchPage.head"));
            data = new GridData();
            data.horizontalSpan = 3;
            this.headButton.setLayoutData((Object)data);
            Label revisionLabel = new Label(this.revisionGroup, 0);
            revisionLabel.setText(Policy.bind("SvnWizardSwitchPage.revision"));
            this.revisionText = new Text(this.revisionGroup, 2048);
            data = new GridData();
            data.widthHint = 40;
            this.revisionText.setLayoutData((Object)data);
            if (this.revisionNumber == 0L) {
                this.headButton.setSelection(true);
                this.revisionText.setEnabled(false);
            } else {
                this.revisionText.setText("" + this.revisionNumber);
            }
            this.revisionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SvnWizardSwitchPage.this.setPageComplete(SvnWizardSwitchPage.this.canFinish());
                }
            });
            FocusAdapter focusListener = new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((Text)e.getSource()).selectAll();
                }

                public void focusLost(FocusEvent e) {
                    ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
                }
            };
            this.revisionText.addFocusListener((FocusListener)focusListener);
            this.logButton = new Button(this.revisionGroup, 8);
            this.logButton.setText(Policy.bind("MergeDialog.showLog"));
            this.logButton.setEnabled(false);
            this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SvnWizardSwitchPage.this.showLog();
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SvnWizardSwitchPage.this.revisionText.setEnabled(!SvnWizardSwitchPage.this.headButton.getSelection());
                    SvnWizardSwitchPage.this.logButton.setEnabled(!SvnWizardSwitchPage.this.headButton.getSelection());
                    SvnWizardSwitchPage.this.setPageComplete(SvnWizardSwitchPage.this.canFinish());
                    if (!SvnWizardSwitchPage.this.headButton.getSelection()) {
                        SvnWizardSwitchPage.this.revisionText.selectAll();
                        SvnWizardSwitchPage.this.revisionText.setFocus();
                    }
                }
            };
            this.headButton.addSelectionListener((SelectionListener)listener);
        }
        if (this.resources.length > 1) {
            this.table = new Table(composite, 2816);
            this.table.setLinesVisible(false);
            this.table.setHeaderVisible(true);
            data = new GridData(1808);
            data.horizontalSpan = 3;
            this.table.setLayoutData((Object)data);
            TableLayout tableLayout = new TableLayout();
            this.table.setLayout((Layout)tableLayout);
            this.viewer = new TableViewer(this.table);
            this.viewer.setContentProvider((IContentProvider)new SwitchContentProvider());
            ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
            this.viewer.setLabelProvider((IBaseLabelProvider)new TableDecoratingLabelProvider((ILabelProvider)new SwitchLabelProvider(), decorator));
            int i = 0;
            while (i < this.columnHeaders.length) {
                tableLayout.addColumnData(this.columnLayouts[i]);
                TableColumn tc = new TableColumn(this.table, 0, i);
                tc.setResizable(this.columnLayouts[i].resizable);
                tc.setText(this.columnHeaders[i]);
                ++i;
            }
            this.viewer.setInput((Object)this);
            this.urlCombo.getCombo().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SvnWizardSwitchPage.this.viewer.refresh();
                }
            });
        }
        Group parameterGroup = new Group(composite, 0);
        GridLayout parameterLayout = new GridLayout();
        parameterLayout.numColumns = 2;
        parameterGroup.setLayout((Layout)parameterLayout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        parameterGroup.setLayoutData((Object)data);
        Label depthLabel = new Label((Composite)parameterGroup, 0);
        depthLabel.setText(Policy.bind("SvnDialog.depth"));
        this.depthCombo = new Combo((Composite)parameterGroup, 8);
        DepthComboHelper.addDepths(this.depthCombo, true, true, "Working copy");
        this.depthCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (SvnWizardSwitchPage.this.depthCombo.getText().equals("Exclude")) {
                    SvnWizardSwitchPage.this.setDepthButton.setSelection(true);
                    SvnWizardSwitchPage.this.setDepthButton.setEnabled(false);
                    SvnWizardSwitchPage.this.ignoreExternalsButton.setVisible(false);
                    SvnWizardSwitchPage.this.forceButton.setVisible(false);
                    SvnWizardSwitchPage.this.ignoreAncestryButton.setVisible(false);
                    if (SvnWizardSwitchPage.this.revisionGroup != null) {
                        SvnWizardSwitchPage.this.revisionGroup.setVisible(false);
                    }
                } else {
                    SvnWizardSwitchPage.this.setDepthButton.setEnabled(true);
                    SvnWizardSwitchPage.this.ignoreExternalsButton.setVisible(true);
                    SvnWizardSwitchPage.this.forceButton.setVisible(true);
                    SvnWizardSwitchPage.this.ignoreAncestryButton.setVisible(true);
                    if (SvnWizardSwitchPage.this.revisionGroup != null) {
                        SvnWizardSwitchPage.this.revisionGroup.setVisible(true);
                    }
                }
                SvnWizardSwitchPage.this.setPageComplete(SvnWizardSwitchPage.this.canFinish());
            }
        });
        this.setDepthButton = new Button((Composite)parameterGroup, 32);
        this.setDepthButton.setText(Policy.bind("SvnDialog.setDepth"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.setDepthButton.setLayoutData((Object)data);
        this.ignoreExternalsButton = new Button((Composite)parameterGroup, 32);
        this.ignoreExternalsButton.setText(Policy.bind("SvnDialog.ignoreExternals"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.ignoreExternalsButton.setLayoutData((Object)data);
        this.forceButton = new Button((Composite)parameterGroup, 32);
        this.forceButton.setText(Policy.bind("SvnDialog.force"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.forceButton.setLayoutData((Object)data);
        this.forceButton.setSelection(true);
        this.ignoreAncestryButton = new Button((Composite)parameterGroup, 32);
        this.ignoreAncestryButton.setText(Policy.bind("SvnWizardSwitchPage.0"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.ignoreAncestryButton.setLayoutData((Object)data);
        this.ignoreAncestryButton.setSelection(false);
        Group conflictGroup = new Group(composite, 0);
        conflictGroup.setText(Policy.bind("SvnWizardUpdatePage.0"));
        GridLayout conflictLayout = new GridLayout();
        conflictLayout.numColumns = 1;
        conflictGroup.setLayout((Layout)conflictLayout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        conflictGroup.setLayoutData((Object)data);
        Group textGroup = new Group((Composite)conflictGroup, 0);
        textGroup.setText(Policy.bind("SvnWizardUpdatePage.1"));
        GridLayout textLayout = new GridLayout();
        textLayout.numColumns = 1;
        textGroup.setLayout((Layout)textLayout);
        textGroup.setLayoutData((Object)new GridData(768));
        this.textConflictPromptButton = new Button((Composite)textGroup, 16);
        this.textConflictPromptButton.setText(Policy.bind("SvnWizardUpdatePage.2"));
        this.textConflictMarkButton = new Button((Composite)textGroup, 16);
        this.textConflictMarkButton.setText(Policy.bind("SvnWizardUpdatePage.3"));
        Group binaryGroup = new Group((Composite)conflictGroup, 0);
        binaryGroup.setText(Policy.bind("SvnWizardUpdatePage.4"));
        GridLayout binaryLayout = new GridLayout();
        binaryLayout.numColumns = 1;
        binaryGroup.setLayout((Layout)binaryLayout);
        binaryGroup.setLayoutData((Object)new GridData(768));
        this.binaryConflictPromptButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictPromptButton.setText(Policy.bind("SvnWizardUpdatePage.5"));
        this.binaryConflictMarkButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictMarkButton.setText(Policy.bind("SvnWizardUpdatePage.6"));
        this.binaryConflictUserButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictUserButton.setText(Policy.bind("SvnWizardUpdatePage.7"));
        this.binaryConflictIncomingButton = new Button((Composite)binaryGroup, 16);
        this.binaryConflictIncomingButton.setText(Policy.bind("SvnWizardUpdatePage.8"));
        Group propertyGroup = new Group((Composite)conflictGroup, 0);
        propertyGroup.setText(Policy.bind("SvnWizardUpdatePage.9"));
        GridLayout propertyLayout = new GridLayout();
        propertyLayout.numColumns = 1;
        propertyGroup.setLayout((Layout)propertyLayout);
        propertyGroup.setLayoutData((Object)new GridData(768));
        this.propertyConflictPromptButton = new Button((Composite)propertyGroup, 16);
        this.propertyConflictPromptButton.setText(Policy.bind("SvnWizardUpdatePage.10"));
        this.propertyConflictMarkButton = new Button((Composite)propertyGroup, 16);
        this.propertyConflictMarkButton.setText(Policy.bind("SvnWizardUpdatePage.11"));
        Group treeConflictGroup = new Group((Composite)conflictGroup, 0);
        treeConflictGroup.setText(Policy.bind("SvnWizardUpdatePage.12"));
        GridLayout treeConflictLayout = new GridLayout();
        treeConflictLayout.numColumns = 1;
        treeConflictGroup.setLayout((Layout)treeConflictLayout);
        treeConflictGroup.setLayoutData((Object)new GridData(768));
        this.treeConflictPromptButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictPromptButton.setText(Policy.bind("SvnWizardUpdatePage.10"));
        this.treeConflictMarkButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictMarkButton.setText(Policy.bind("SvnWizardUpdatePage.11"));
        this.treeConflictUserButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictUserButton.setText(Policy.bind("SvnWizardUpdatePage.13"));
        this.treeConflictResolveButton = new Button((Composite)treeConflictGroup, 16);
        this.treeConflictResolveButton.setText(Policy.bind("SvnWizardUpdatePage.14"));
        this.textConflictMarkButton.setSelection(true);
        this.binaryConflictMarkButton.setSelection(true);
        this.propertyConflictMarkButton.setSelection(true);
        this.treeConflictMarkButton.setSelection(true);
        this.setPageComplete(this.canFinish());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.switch_dialog_context");
    }

    @Override
    public String getWindowTitle() {
        return Policy.bind("SwitchDialog.switch");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    protected void showLog() {
        ISVNRemoteFile remoteResource = null;
        try {
            remoteResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[0]).getRepository().getRemoteFile(new SVNUrl(this.urlCombo.getText()));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)e.toString());
            return;
        }
        if (remoteResource == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("MergeDialog.showLog"), (String)(String.valueOf(Policy.bind("MergeDialog.urlError")) + " " + this.urlCombo.getText()));
            return;
        }
        HistoryDialog dialog = new HistoryDialog(this.getShell(), (ISVNRemoteResource)remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setPageComplete(this.canFinish());
    }

    @Override
    public boolean performFinish() {
        block9: {
            try {
                if (!this.showUrl) break block9;
                this.urlCombo.saveUrl();
                if (this.urlStrings.length > 1) {
                    this.urls = new SVNUrl[this.switchResources.length];
                    int i = 0;
                    while (i < this.switchResources.length) {
                        this.urls[i] = this.urlCombo.getText().endsWith("/") ? new SVNUrl(String.valueOf(this.urlCombo.getText()) + this.switchResources[i].getPartialPath()) : new SVNUrl(String.valueOf(this.urlCombo.getText()) + "/" + this.switchResources[i].getPartialPath());
                        ++i;
                    }
                } else {
                    this.urls = new SVNUrl[1];
                    this.urls[0] = new SVNUrl(this.urlCombo.getText());
                }
                if (this.headButton.getSelection()) {
                    this.revision = SVNRevision.HEAD;
                    break block9;
                }
                try {
                    this.revision = SVNRevision.getRevision((String)this.revisionText.getText().trim());
                }
                catch (ParseException parseException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("SwitchDialog.title"), (String)Policy.bind("SwitchDialog.invalid"));
                    return false;
                }
            }
            catch (MalformedURLException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("SwitchDialog.title"), (String)e.getMessage());
                return false;
            }
        }
        this.setDepth = this.setDepthButton.getSelection();
        this.ignoreExternals = this.ignoreExternalsButton.getSelection();
        this.force = this.forceButton.getSelection();
        this.ignoreAncestry = this.ignoreAncestryButton.getSelection();
        this.depth = DepthComboHelper.getDepth(this.depthCombo);
        this.conflictResolver = new SVNConflictResolver(this.resources[0], this.getTextConflictHandling(), this.getBinaryConflictHandling(), this.getPropertyConflictHandling(), this.getTreeConflictHandling());
        return true;
    }

    @Override
    public void saveSettings() {
    }

    public SVNConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public int getTextConflictHandling() {
        if (this.textConflictMarkButton.getSelection()) {
            return 0;
        }
        return 6;
    }

    public int getBinaryConflictHandling() {
        if (this.binaryConflictIncomingButton.getSelection()) {
            return 2;
        }
        if (this.binaryConflictUserButton.getSelection()) {
            return 3;
        }
        if (this.binaryConflictMarkButton.getSelection()) {
            return 0;
        }
        return 6;
    }

    public int getPropertyConflictHandling() {
        if (this.propertyConflictMarkButton.getSelection()) {
            return 0;
        }
        return 6;
    }

    public int getTreeConflictHandling() {
        if (this.treeConflictMarkButton.getSelection()) {
            return 0;
        }
        if (this.treeConflictResolveButton.getSelection()) {
            return 6;
        }
        if (this.treeConflictUserButton.getSelection()) {
            return 5;
        }
        return -1;
    }

    @Override
    public void setMessage() {
        this.setMessage(Policy.bind("SwitchDialog.message"));
    }

    private boolean canFinish() {
        this.setErrorMessage(null);
        if (this.showUrl) {
            if (this.urlCombo.getText().length() <= 0 || !this.headButton.getSelection() && this.revisionText.getText().trim().length() <= 0) {
                return false;
            }
            if (this.depthCombo.getText().equals("Exclude") && (this.commonRoot == null || !this.urlCombo.getText().equals(this.commonRoot))) {
                this.setErrorMessage(Policy.bind("SwitchDialog.excludeAndSwitchError"));
                return false;
            }
        }
        return true;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public SVNUrl[] getUrls() {
        return this.urls;
    }

    private String getCommonRoot() {
        ArrayList<String> urlList = new ArrayList<String>();
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
            try {
                String anUrl = svnResource.getStatus().getUrlString();
                if (anUrl != null) {
                    urlList.add(anUrl);
                }
            }
            catch (SVNException sVNException) {}
            ++n2;
        }
        this.urlStrings = new String[urlList.size()];
        urlList.toArray(this.urlStrings);
        if (this.urlStrings.length == 0) {
            return null;
        }
        String urlString = this.urlStrings[0];
        if (this.urlStrings.length == 1) {
            return urlString;
        }
        String commonRoot = null;
        int i = 0;
        block3: while (i < urlString.length()) {
            String partialPath = urlString.substring(0, i + 1);
            if (partialPath.endsWith("/")) {
                int j = 1;
                while (j < this.urlStrings.length) {
                    if (!this.urlStrings[j].startsWith(partialPath)) break block3;
                    ++j;
                }
                commonRoot = partialPath.substring(0, i);
            }
            ++i;
        }
        this.switchResources = new SwitchResource[this.resources.length];
        i = 0;
        while (i < this.resources.length) {
            this.switchResources[i] = new SwitchResource(this.resources[i], this.urlStrings[i].substring(commonRoot.length() + 1));
            ++i;
        }
        return commonRoot;
    }

    @Override
    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isSetDepth() {
        return this.setDepth;
    }

    public boolean isIgnoreExternals() {
        return this.ignoreExternals;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    class SwitchContentProvider
    implements IStructuredContentProvider {
        SwitchContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object obj) {
            return SvnWizardSwitchPage.this.switchResources;
        }
    }

    class SwitchLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        SwitchLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }

        public String getText(Object element) {
            SwitchResource switchResource = (SwitchResource)element;
            return String.valueOf(switchResource.getPartialPath()) + " [" + SvnWizardSwitchPage.this.urlCombo.getText() + "/" + switchResource.getPartialPath() + "]";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }

        public Image getImage(Object element) {
            SwitchResource switchResource = (SwitchResource)element;
            return this.workbenchLabelProvider.getImage((Object)switchResource.getResource());
        }
    }

    private class SwitchResource
    implements IAdaptable {
        private IResource resource;
        private String partialPath;

        public SwitchResource(IResource resource, String partialPath) {
            this.resource = resource;
            this.partialPath = partialPath;
        }

        public IResource getResource() {
            return this.resource;
        }

        public String getPartialPath() {
            return this.partialPath;
        }

        public Object getAdapter(Class adapter) {
            if (IResource.class == adapter) {
                return this.resource;
            }
            return null;
        }
    }

    class TableDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        ITableLabelProvider provider;
        ILabelDecorator decorator;

        public TableDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
            this.provider = (ITableLabelProvider)provider;
            this.decorator = decorator;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image decorated;
            Image image = this.provider.getColumnImage(element, columnIndex);
            if (this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
                return decorated;
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = this.provider.getColumnText(element, columnIndex);
            return text;
        }
    }
}

