/*******************************************************************************
 * Copyright (C) 2010 - 2016. TIBCO Software Inc. 
 * All Rights Reserved. Confidential & Proprietary.
 ******************************************************************************/
package com.jaspersoft.studio.editor.gef.figures.util;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
 /*/*
 * The Class RoundGradientPaint.
 * 
 * @author gtoffoli
 */
public class RoundGradientPaint implements Paint {
  
  /** The m point. */
  protected Point2D mPoint;
  
  /** The m radius. */
  protected Point2D mRadius;
  
  /** The m background color. */
  protected Color mPointColor, mBackgroundColor;
  
  /**
	 * Instantiates a new round gradient paint.
	 * 
	 * @param x
	 *          the x
	 * @param y
	 *          the y
	 * @param pointColor
	 *          the point color
	 * @param radius
	 *          the radius
	 * @param backgroundColor
	 *          the background color
	 */
  public RoundGradientPaint(double x, double y, Color pointColor,
      Point2D radius, Color backgroundColor) {
      mPoint = new Point2D.Double(x, y);
      mPointColor = pointColor;
      mRadius = radius;
      mBackgroundColor = backgroundColor;
  }
  
  /* (non-Javadoc)
   * @see java.awt.Paint#createContext(java.awt.image.ColorModel, java.awt.Rectangle, java.awt.geom.Rectangle2D, java.awt.geom.AffineTransform, java.awt.RenderingHints)
   */
  public PaintContext createContext(ColorModel cm,
      Rectangle deviceBounds, Rectangle2D userBounds,
      AffineTransform xform, RenderingHints hints) {
    Point2D transformedPoint = xform.transform(mPoint, null);
    Point2D transformedRadius = xform.deltaTransform(mRadius, null);
    return new RoundGradientContext(transformedPoint, mPointColor,
        transformedRadius, mBackgroundColor);
  }
  
  /* (non-Javadoc)
   * @see java.awt.Transparency#getTransparency()
   */
  public int getTransparency() {
    int a1 = mPointColor.getAlpha();
    int a2 = mBackgroundColor.getAlpha();
    return (((a1 & a2) == 0xff) ? OPAQUE : TRANSLUCENT);
  }
}


