/*******************************************************************************
 * Copyright (C) 2010 - 2016. TIBCO Software Inc. 
 * All Rights Reserved. Confidential & Proprietary.
 ******************************************************************************/
package com.jaspersoft.studio.model.band;

import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRConstants;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.type.BandTypeEnum;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;

/*
 * The Class MBandGroupFooter.
 * 
 * @author Chicu Veaceslav
 */
public class MBandGroupFooter extends MBandGroup {
	
	public static final long serialVersionUID = JRConstants.SERIAL_VERSION_UID;

	/** The icon descriptor. */
	private static IIconDescriptor iconDescriptor;

	/**
	 * Instantiates a new m band group footer.
	 */
	public MBandGroupFooter() {
		super();
	}

	/**
	 * Instantiates a new m band group footer.
	 * 
	 * @param parent
	 *          the parent
	 * @param jrGroup
	 *          the jr group
	 * @param jrband
	 *          the jrband
	 * @param index
	 *          the index
	 */
	public MBandGroupFooter(ANode parent, JRDesignGroup jrGroup, JRBand jrband, int index) {
		super(parent, jrGroup, jrband, BandTypeEnum.GROUP_FOOTER, index);
	}

	/**
	 * Gets the icon descriptor.
	 * 
	 * @return the icon descriptor
	 */
	protected IIconDescriptor getLocalIconDescriptor() {
		if (iconDescriptor == null)
			iconDescriptor = new NodeIconDescriptor("groupfooter"); //$NON-NLS-1$
		return iconDescriptor;
	}
	
	@Override
	public JRSection getSection(){
		return getJrGroup().getGroupFooterSection();
	}

	@Override
	public String getDisplayText() {
		if (getJrGroup() == null)
			return super.getDisplayText();
		JRDesignBand value = (JRDesignBand) getValue();
		String index = "";
		if (bandIndex != -1)
			index = " " + String.valueOf(bandIndex);
		if (value != null)
			return jrGroup.getName()
					+ " " + Messages.MBandGroupFooter_group_footer + index + " [" + value.getHeight() + "px] ";// + value.hashCode(); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		return jrGroup.getName() + " " + Messages.MBandGroupFooter_group_footer + index; //$NON-NLS-1$
	}

	@Override
	public String getSimpleDisplayName() {
		if (getJrGroup() == null)
			return super.getSimpleDisplayName();
		String index = "";
		if (bandIndex != -1)
			index = " " + String.valueOf(bandIndex);
		return jrGroup.getName() + " " + Messages.MBandGroupFooter_group_footer + index; //$NON-NLS-1$
	}
}
