/*******************************************************************************
 * Copyright (C) 2010 - 2016. TIBCO Software Inc. 
 * All Rights Reserved. Confidential & Proprietary.
 ******************************************************************************/
package net.sf.jasperreports.eclipse.classpath;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class ClassLoaderUtil {

	public static ClassLoader getClassLoader4Project(IProgressMonitor monitor, IProject activeProject)
			throws CoreException {
		if (activeProject.hasNature(JavaCore.NATURE_ID)) {
			IJavaProject javaProject = JavaCore.create(activeProject);
			javaProject.open(monitor);
			return JavaProjectClassLoader.instance(javaProject, Thread.currentThread().getContextClassLoader());
		}
		return activeProject.getClass().getClassLoader();
	}

	public static Set<String> packages = new HashSet<>();
	static {
		packages.add("java");
		packages.add("java.lang");
		packages.add("java.lang.JRFillVariable");
		packages.add("java.util.Throwable");
		packages.add("java.util.Object");
		packages.add("java.lang.java");
		packages.add("java.util.java");
		packages.add("net");
		packages.add("net.sf");
		packages.add("net.sf.jasperreports");
		packages.add("net.sf.jasperreports.engine");
		packages.add("net.sf.jasperreports.engine.fill");
		packages.add("java.util");
		packages.add("java.math");
		packages.add("java.text");
		packages.add("java.io");
		packages.add("java.net");
		packages.add("Object");
		packages.add("JREvaluator");
		packages.add("JRFillParameter");
		packages.add("JRFillVariable");
		packages.add("Map");
		packages.add("Throwable");
		packages.add("java.lang.JREvaluator");
		packages.add("net.sf.jasperreports.engine.JREvaluator");
		packages.add("java.lang.package-info");
		packages.add("java.util.JREvaluator");
		packages.add("java.math.JREvaluator");
		packages.add("java.text.JREvaluator");
		packages.add("java.io.JREvaluator");
		packages.add("java.net.JREvaluator");
		packages.add("java.lang.JRFillParameter");
		packages.add("net.sf.jasperreports.engine.JRFillParameter");
		packages.add("java.util.JRFillParameter");
		packages.add("java.math.JRFillParameter");
		packages.add("java.text.JRFillParameter");
		packages.add("java.io.JRFillParameter");
		packages.add("java.net.JRFillParameter");
		packages.add("java.lang.JRFillParameter");
		packages.add("net.sf.jasperreports.engine.JRFillVariable");
		packages.add("java.util.JRFillVariable");
		packages.add("java.math.JRFillVariable");
		packages.add("java.text.JRFillVariable");
		packages.add("java.io.JRFillVariable");
		packages.add("java.net.JRFillVariable");
		packages.add("java.lang.Map");
		packages.add("net.sf.jasperreports.engine.Map");
		packages.add("net.sf.jasperreports.engine.fill.Map");
		packages.add("java.util.package-info");
		packages.add("java.math.Map");
		packages.add("java.text.Map");
		packages.add("java.io.Map");
		packages.add("java.net.Map");
		packages.add("net.sf.jasperreports.engine.Throwable");
		packages.add("net.sf.jasperreports.engine.fill.Throwable");
		packages.add("java.math.Throwable");
		packages.add("java.text.Throwable");
		packages.add("java.io.Throwable");
		packages.add("java.net.Throwable");
		packages.add("net.sf.jasperreports.engine.Object");
		packages.add("net.sf.jasperreports.engine.fill.Object");
		packages.add("java.math.Object");
		packages.add("java.text.Object");
		packages.add("java.io.Object");
		packages.add("java.net.Object");
		packages.add("net.sf.jasperreports.engine.java");
		packages.add("net.sf.jasperreports.engine.fill.java");
		packages.add("java.math.java");
		packages.add("java.text.java");
		packages.add("java.io.java");
		packages.add("java.net.java");
		packages.add("java.io.package-info");
		packages.add("net.sf.jasperreports.engine.String");
		packages.add("net.sf.jasperreports.engine.fill.String");
		packages.add("java.util.String");
		packages.add("java.math.String");
		packages.add("java.text.String");
		packages.add("java.io.String");
		packages.add("java.net.String");
		packages.add("java.lang.net.sf.jasperreports.engine.java$sql$Connection");
		packages.add("java.io.net.sf.jasperreports.engine.java$sql$Connection");
		packages.add("java.net.net.sf.jasperreports.engine.java$sql$Connection");
		packages.add("java.util.net.sf.jasperreports.engine.java$sql$Connection");
		packages.add("groovy.lang.net.sf.jasperreports.engine.java$sql$Connection");
		packages.add("groovy.util.net.sf.jasperreports.engine.java$sql$Connection");
		packages.add("net.sf.jasperreports.engine.java$sql$Connection");
		packages.add("net.sf.jasperreports.engine.java.sql$Connection");
		packages.add("net.sf.jasperreports.engine.java.sql.Connection");
		packages.add("java.lang.net.sf.jasperreports.engine.fill.java$sql$Connection");
		packages.add("java.io.net.sf.jasperreports.engine.fill.java$sql$Connection");
		packages.add("java.net.net.sf.jasperreports.engine.fill.java$sql$Connection");
		packages.add("java.util.net.sf.jasperreports.engine.fill.java$sql$Connection");
		packages.add("groovy.lang.net.sf.jasperreports.engine.fill.java$sql$Connection");
		packages.add("groovy.util.net.sf.jasperreports.engine.fill.java$sql$Connection");
		packages.add("net.sf.jasperreports.engine.fill.java$sql$Connection");
		packages.add("net.sf.jasperreports.engine.fill.java.sql$Connection");
		packages.add("net.sf.jasperreports.engine.fill.java.sql.Connection");
		packages.add("java.lang.java.util.java$sql$Connection");
		packages.add("java.io.java.util.java$sql$Connection");
		packages.add("java.net.java.util.java$sql$Connection");
		packages.add("java.util.java.util.java$sql$Connection");
		packages.add("groovy.lang.java.util.java$sql$Connection");
		packages.add("groovy.util.java.util.java$sql$Connection");
		packages.add("java.util.java$sql$Connection");
		packages.add("java.util.java.sql$Connection");
		packages.add("java.util.java.sql.Connection");
		packages.add("java.lang.java.math.java$sql$Connection");
		packages.add("java.io.java.math.java$sql$Connection");
		packages.add("java.net.java.math.java$sql$Connection");
		packages.add("java.util.java.math.java$sql$Connection");
		packages.add("groovy.lang.java.math.java$sql$Connection");
		packages.add("groovy.util.java.math.java$sql$Connection");
		packages.add("java.math.java$sql$Connection");
		packages.add("java.math.java.sql$Connection");
		packages.add("java.math.java.sql.Connection");
		packages.add("java.lang.java.text.java$sql$Connection");
		packages.add("java.io.java.text.java$sql$Connection");
		packages.add("java.net.java.text.java$sql$Connection");
		packages.add("java.util.java.text.java$sql$Connection");
		packages.add("groovy.lang.java.text.java$sql$Connection");
		packages.add("groovy.util.java.text.java$sql$Connection");
		packages.add("java.text.java$sql$Connection");
		packages.add("java.text.java.sql$Connection");
		packages.add("java.text.java.sql.Connection");
		packages.add("java.lang.java.io.java$sql$Connection");
		packages.add("java.io.java.io.java$sql$Connection");
		packages.add("java.net.java.io.java$sql$Connection");
		packages.add("java.util.java.io.java$sql$Connection");
		packages.add("groovy.lang.java.io.java$sql$Connection");
		packages.add("groovy.util.java.io.java$sql$Connection");
		packages.add("java.io.java$sql$Connection");
		packages.add("java.io.java.sql$Connection");
		packages.add("java.io.java.sql.Connection");
		packages.add("java.lang.java.net.java$sql$Connection");
		packages.add("java.io.java.net.java$sql$Connection");
		packages.add("java.net.java.net.java$sql$Connection");
		packages.add("java.util.java.net.java$sql$Connection");
		packages.add("groovy.lang.java.net.java$sql$Connection");
		packages.add("groovy.util.java.net.java$sql$Connection");
		packages.add("java.net.java$sql$Connection");
		packages.add("java.net.java.sql$Connection");
		packages.add("java.net.java.sql.Connection");
		packages.add("java.lang.java$sql$Connection");
		packages.add("groovy.lang.java$sql$Connection");
		packages.add("groovy.util.java$sql$Connection");
		packages.add("java$sql$Connection");
		packages.add("java.sql$Connection");
		packages.add("net.sf.jasperreports.engine.JRFillField");
		packages.add("java.lang.net.sf.jasperreports.engine.java$sql$Timestamp");
		packages.add("java.io.net.sf.jasperreports.engine.java$sql$Timestamp");
		packages.add("java.net.net.sf.jasperreports.engine.java$sql$Timestamp");
		packages.add("java.util.net.sf.jasperreports.engine.java$sql$Timestamp");
		packages.add("groovy.lang.net.sf.jasperreports.engine.java$sql$Timestamp");
		packages.add("groovy.util.net.sf.jasperreports.engine.java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.java.sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.java.sql.Timestamp");
		packages.add("java.lang.net.sf.jasperreports.engine.fill.java$sql$Timestamp");
		packages.add("java.io.net.sf.jasperreports.engine.fill.java$sql$Timestamp");
		packages.add("java.net.net.sf.jasperreports.engine.fill.java$sql$Timestamp");
		packages.add("java.util.net.sf.jasperreports.engine.fill.java$sql$Timestamp");
		packages.add("groovy.lang.net.sf.jasperreports.engine.fill.java$sql$Timestamp");
		packages.add("groovy.util.net.sf.jasperreports.engine.fill.java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.java.sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.java.sql.Timestamp");
		packages.add("java.lang.java.util.java$sql$Timestamp");
		packages.add("java.io.java.util.java$sql$Timestamp");
		packages.add("java.net.java.util.java$sql$Timestamp");
		packages.add("java.util.java.util.java$sql$Timestamp");
		packages.add("groovy.lang.java.util.java$sql$Timestamp");
		packages.add("groovy.util.java.util.java$sql$Timestamp");
		packages.add("java.util.java$sql$Timestamp");
		packages.add("java.util.java.sql$Timestamp");
		packages.add("java.util.java.sql.Timestamp");
		packages.add("java.lang.java.math.java$sql$Timestamp");
		packages.add("java.io.java.math.java$sql$Timestamp");
		packages.add("java.net.java.math.java$sql$Timestamp");
		packages.add("java.util.java.math.java$sql$Timestamp");
		packages.add("groovy.lang.java.math.java$sql$Timestamp");
		packages.add("groovy.util.java.math.java$sql$Timestamp");
		packages.add("java.math.java$sql$Timestamp");
		packages.add("java.math.java.sql$Timestamp");
		packages.add("java.math.java.sql.Timestamp");
		packages.add("java.lang.java.text.java$sql$Timestamp");
		packages.add("java.io.java.text.java$sql$Timestamp");
		packages.add("java.net.java.text.java$sql$Timestamp");
		packages.add("java.util.java.text.java$sql$Timestamp");
		packages.add("groovy.lang.java.text.java$sql$Timestamp");
		packages.add("groovy.util.java.text.java$sql$Timestamp");
		packages.add("java.text.java$sql$Timestamp");
		packages.add("java.text.java.sql$Timestamp");
		packages.add("java.text.java.sql.Timestamp");
		packages.add("java.lang.java.io.java$sql$Timestamp");
		packages.add("java.io.java.io.java$sql$Timestamp");
		packages.add("java.net.java.io.java$sql$Timestamp");
		packages.add("java.util.java.io.java$sql$Timestamp");
		packages.add("groovy.lang.java.io.java$sql$Timestamp");
		packages.add("groovy.util.java.io.java$sql$Timestamp");
		packages.add("java.io.java$sql$Timestamp");
		packages.add("java.io.java.sql$Timestamp");
		packages.add("java.io.java.sql.Timestamp");
		packages.add("java.lang.java.net.java$sql$Timestamp");
		packages.add("java.io.java.net.java$sql$Timestamp");
		packages.add("java.net.java.net.java$sql$Timestamp");
		packages.add("java.util.java.net.java$sql$Timestamp");
		packages.add("groovy.lang.java.net.java$sql$Timestamp");
		packages.add("groovy.util.java.net.java$sql$Timestamp");
		packages.add("java.net.java$sql$Timestamp");
		packages.add("java.net.java.sql$Timestamp");
		packages.add("java.net.java.sql.Timestamp");
		packages.add("java.lang.java$sql$Timestamp");
		packages.add("groovy.lang.java$sql$Timestamp");
		packages.add("groovy.util.java$sql$Timestamp");
		packages.add("java$sql$Timestamp");

		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$JRFillParameter");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$JRFillParameter");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$JRFillParameter");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$JRFillParameter");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$fill$JRFillParameter");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$fill$JRFillParameter");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$JRFillField");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$JRFillField");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$JRFillField");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$JRFillField");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$fill$JRFillField");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$fill$JRFillField");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$JRFillVariable");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$JRFillVariable");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$JRFillVariable");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$JRFillVariable");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$fill$JRFillVariable");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$fill$JRFillVariable");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$String");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$String");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$String");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$String");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$fill$String");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$fill$String");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$String");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$String");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$math$String");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$math$String");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$text$String");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$text$String");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$String");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$String");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$String");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$String");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$String");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$String");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$Map");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$Map");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$Map");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$Map");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$fill$Map");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$fill$Map");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$Map");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$Map");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$Object");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$Object");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$Object");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$Object");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$fill$Object");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$fill$Object");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$Object");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$Object");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$math$Object");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$math$Object");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$text$Object");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$text$Object");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$Object");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$Object");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$Object");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$Object");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$Object");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$Object");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$net$sf$jasperreports$engine$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$net$sf$jasperreports$engine$java$util$Date");
		packages.add("java.lang.net.sf.jasperreports.engine.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$net$sf$jasperreports$engine$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$net$sf$jasperreports$engine$java$util$Date");
		packages.add("java.io.net.sf.jasperreports.engine.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$net$sf$jasperreports$engine$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$net$sf$jasperreports$engine$java$util$Date");
		packages.add("java.net.net.sf.jasperreports.engine.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$net$sf$jasperreports$engine$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$net$sf$jasperreports$engine$java$util$Date");
		packages.add("java.util.net.sf.jasperreports.engine.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$net$sf$jasperreports$engine$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$net$sf$jasperreports$engine$java$util$Date");
		packages.add("groovy.lang.net.sf.jasperreports.engine.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$net$sf$jasperreports$engine$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$net$sf$jasperreports$engine$java$util$Date");
		packages.add("groovy.util.net.sf.jasperreports.engine.java$util$Date");
		packages.add("net.sf.jasperreports.engine.java$util$Date");
		packages.add("net.sf.jasperreports.engine.java.util$Date");
		packages.add("net.sf.jasperreports.engine.java.util.Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add("java.lang.net.sf.jasperreports.engine.fill.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add("java.io.net.sf.jasperreports.engine.fill.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add("java.net.net.sf.jasperreports.engine.fill.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add("java.util.net.sf.jasperreports.engine.fill.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add("groovy.lang.net.sf.jasperreports.engine.fill.java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$net$sf$jasperreports$engine$fill$java$util$Date");
		packages.add("groovy.util.net.sf.jasperreports.engine.fill.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.java.util$Date");
		packages.add("net.sf.jasperreports.engine.fill.java.util.Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$util$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$util$java$util$Date");
		packages.add("java.lang.java.util.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$util$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$util$java$util$Date");
		packages.add("java.io.java.util.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$util$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$util$java$util$Date");
		packages.add("java.net.java.util.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$util$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$util$java$util$Date");
		packages.add("java.util.java.util.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$util$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$util$java$util$Date");
		packages.add("groovy.lang.java.util.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$util$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$util$java$util$Date");
		packages.add("groovy.util.java.util.java$util$Date");
		packages.add("java.util.java$util$Date");
		packages.add("java.util.java.util$Date");
		packages.add("java.util.java.util.Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$math$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$math$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$math$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$math$java$util$Date");
		packages.add("java.lang.java.math.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$math$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$math$java$util$Date");
		packages.add("java.io.java.math.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$math$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$math$java$util$Date");
		packages.add("java.net.java.math.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$math$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$math$java$util$Date");
		packages.add("java.util.java.math.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$math$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$math$java$util$Date");
		packages.add("groovy.lang.java.math.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$math$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$math$java$util$Date");
		packages.add("groovy.util.java.math.java$util$Date");
		packages.add("java.math.java$util$Date");
		packages.add("java.math.java.util$Date");
		packages.add("java.math.java.util.Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$text$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$text$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$text$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$text$java$util$Date");
		packages.add("java.lang.java.text.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$text$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$text$java$util$Date");
		packages.add("java.io.java.text.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$text$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$text$java$util$Date");
		packages.add("java.net.java.text.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$text$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$text$java$util$Date");
		packages.add("java.util.java.text.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$text$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$text$java$util$Date");
		packages.add("groovy.lang.java.text.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$text$java$util$Date");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$text$java$util$Date");
		packages.add("groovy.util.java.text.java$util$Date");
		packages.add("java.text.java$util$Date");
		packages.add("java.text.java.util$Date");
		packages.add("java.text.java.util.Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$io$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$io$java$util$Date");
		packages.add("java.lang.java.io.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$io$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$io$java$util$Date");
		packages.add("java.io.java.io.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$io$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$io$java$util$Date");
		packages.add("java.net.java.io.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$io$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$io$java$util$Date");
		packages.add("java.util.java.io.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$io$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$io$java$util$Date");
		packages.add("groovy.lang.java.io.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$io$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$io$java$util$Date");
		packages.add("groovy.util.java.io.java$util$Date");
		packages.add("java.io.java$util$Date");
		packages.add("java.io.java.util$Date");
		packages.add("java.io.java.util.Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$net$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$net$java$util$Date");
		packages.add("java.lang.java.net.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$net$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$net$java$util$Date");
		packages.add("java.io.java.net.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$net$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$net$java$util$Date");
		packages.add("java.net.java.net.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$net$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$net$java$util$Date");
		packages.add("java.util.java.net.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$net$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$net$java$util$Date");
		packages.add("groovy.lang.java.net.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$net$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$net$java$util$Date");
		packages.add("groovy.util.java.net.java$util$Date");
		packages.add("java.net.java$util$Date");
		packages.add("java.net.java.util$Date");
		packages.add("java.net.java.util.Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$util$Date");
		packages.add("java.lang.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$util$Date");
		packages.add("groovy.lang.java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$util$Date");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$util$Date");
		packages.add("groovy.util.java$util$Date");
		packages.add("java$util$Date");
		packages.add("java.util$Date");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$net$sf$jasperreports$engine$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$net$sf$jasperreports$engine$fill$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$util$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$util$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$util$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$math$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$math$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$math$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$math$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$text$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$text$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$text$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$text$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$io$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$io$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$io$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$io$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$io$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$io$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$io$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$io$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$io$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$io$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$io$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$io$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$net$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$net$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$io$java$net$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$io$java$net$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$net$java$net$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$net$java$net$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$util$java$net$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$util$java$net$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$net$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$net$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$net$java$sql$Timestamp");
		packages.add(
				"net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$net$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$java$lang$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$java$lang$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$lang$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$lang$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.JasperReportsContextAware$groovy$util$java$sql$Timestamp");
		packages.add("net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator$groovy$util$java$sql$Timestamp");
		packages.add("java.sql$Timestamp");
		packages.add("groovy.lang.ExpandoMetaClassBeanInfo");
		packages.add("groovy.lang.MetaClassImplBeanInfo");
		packages.add("java.lang.ObjectBeanInfo");
		packages.add("java.lang.ObjectCustomizer");
		packages.add("groovy.lang.MetaClassImplCustomizer");
		packages.add("groovy.lang.ExpandoMetaClassCustomizer");
		packages.add("net.sf.jasperreports.compilers.GroovyEvaluatorBeanInfo");
		packages.add("net.sf.jasperreports.engine.fill.JREvaluatorBeanInfo");
		packages.add("net.sf.jasperreports.engine.fill.JREvaluatorCustomizer");
		packages.add("net.sf.jasperreports.compilers.GroovyEvaluatorCustomizer");
		packages.add("java.util.HashMapBeanInfo");
		packages.add("java.util.AbstractMapBeanInfo");
		packages.add("java.util.AbstractMapCustomizer");
		packages.add("java.util.HashMapCustomizer");
		packages.add("java.util.DateBeanInfo");
		packages.add("java.util.DateCustomizer");
		packages.add("net.sf.jasperreports.engine.fill.JRFillFieldBeanInfo");
		packages.add("net.sf.jasperreports.engine.fill.JRFillFieldCustomizer");
		packages.add("net.sf.jasperreports.engine.fill.JRFillVariableBeanInfo");
		packages.add("net.sf.jasperreports.engine.fill.JRFillVariableCustomizer");
		packages.add("java.lang.IntegerBeanInfo");
		packages.add("java.lang.NumberBeanInfo");
		packages.add("java.lang.NumberCustomizer");
		packages.add("java.lang.IntegerCustomizer");
		packages.add("java.lang.StringBeanInfo");
		packages.add("java.lang.StringCustomizer");
	}
	
	public static Set<String> EXCLUDE_SUFFIXES = new HashSet<>();
	static {
		EXCLUDE_SUFFIXES.add("$engine");
		EXCLUDE_SUFFIXES.add("$fill");
		EXCLUDE_SUFFIXES.add("$util");
		EXCLUDE_SUFFIXES.add("$math");
		EXCLUDE_SUFFIXES.add("$text");
		EXCLUDE_SUFFIXES.add("$net");
		EXCLUDE_SUFFIXES.add("$String");
		EXCLUDE_SUFFIXES.add("$Map");
		EXCLUDE_SUFFIXES.add("$Object");
		EXCLUDE_SUFFIXES.add("$io");
		EXCLUDE_SUFFIXES.add("$Date");
		EXCLUDE_SUFFIXES.add("$Connection");
		EXCLUDE_SUFFIXES.add("$Timestamp");
		EXCLUDE_SUFFIXES.add("$JRFillVariable");
		EXCLUDE_SUFFIXES.add("$JRFillField");
		EXCLUDE_SUFFIXES.add("$JRFillParameter");
	}
}
