/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.adapters;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionHelper {
    private static Method accessible0;

    private static void setAccessible(AccessibleObject obj) throws InvocationTargetException, IllegalAccessException {
        accessible0.invoke((Object)obj, true);
    }

    public static <T> T invoke(Class cls, Object obj, String methodName) {
        try {
            Method method = cls.getDeclaredMethod(methodName, new Class[0]);
            ReflectionHelper.setAccessible(method);
            return (T)method.invoke(obj, new Object[0]);
        }
        catch (Throwable ex) {
            throw new InternalError(ex);
        }
    }

    public static <T> T invoke(Object obj, String methodName) {
        return ReflectionHelper.invoke(obj.getClass(), obj, methodName);
    }

    public static Method getMethod(Class cls, String methodName) {
        try {
            Method method = cls.getDeclaredMethod(methodName, new Class[0]);
            ReflectionHelper.setAccessible(method);
            return method;
        }
        catch (Throwable ex) {
            throw new InternalError(ex);
        }
    }

    public static Field getField(Class cls, String fieldName) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            ReflectionHelper.setAccessible(field);
            return field;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <T> T getFieldContent(Object obj, String fieldName) {
        return ReflectionHelper.getFieldContent(obj.getClass(), obj, fieldName);
    }

    public static <T> T getFieldContent(Class cls, Object obj, String fieldName) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            ReflectionHelper.setAccessible(field);
            return (T)field.get(obj);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static void setFieldContent(Class cls, Object obj, String fieldName, Object content) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            ReflectionHelper.setAccessible(field);
            field.set(obj, content);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        try {
            accessible0 = AccessibleObject.class.getDeclaredMethod("setAccessible0", Boolean.TYPE);
            accessible0.setAccessible(true);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

