/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.skins.JFXColorPickerSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.converter.BooleanConverter;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class JFXColorPicker
extends ColorPicker {
    private static final String DEFAULT_STYLE_CLASS = "jfx-color-picker";
    private double[] preDefinedColors = null;
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.access$000(), (Object)this, "disableAnimation", false);

    public JFXColorPicker() {
        this.initialize();
    }

    public JFXColorPicker(Color color) {
        super(color);
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXColorPickerSkin(this);
    }

    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-color-picker.css").toExternalForm();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public double[] getPreDefinedColors() {
        return this.preDefinedColors;
    }

    public void setPreDefinedColors(double[] preDefinedColors) {
        this.preDefinedColors = preDefinedColors;
    }

    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    public final void setDisableAnimation(Boolean disabled) {
        this.disableAnimationProperty().set(disabled.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXColorPicker.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXColorPicker, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXColorPicker, Boolean>("-jfx-disable-animation", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXColorPicker control) {
                return control.disableAnimation == null || !control.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXColorPicker control) {
                return control.disableAnimationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return DISABLE_ANIMATION;
        }

        static {
            ArrayList styleables = new ArrayList(ColorPicker.getClassCssMetaData());
            Collections.addAll(styleables, DISABLE_ANIMATION);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

