/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors.base;

import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.controls.cells.editors.base.GenericEditableTreeTableCell;
import java.util.function.Consumer;
import javafx.scene.input.MouseEvent;

public class OnPressedEditableTreeTableCell<S, T>
extends GenericEditableTreeTableCell<S, T> {
    public OnPressedEditableTreeTableCell() {
        this.init();
    }

    public OnPressedEditableTreeTableCell(EditorNodeBuilder builder) {
        super(builder);
        this.init();
    }

    public OnPressedEditableTreeTableCell(EditorNodeBuilder builder, Consumer<Exception> exConsumer) {
        super(builder, exConsumer);
        this.init();
    }

    private void init() {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, click -> {
            OnPressedEditableTreeTableCell editingCell;
            if (this.getTreeTableView().getEditingCell() != null && !this.isEditing() && (editingCell = (OnPressedEditableTreeTableCell)((Object)((Object)this.getTreeTableView().getProperties().remove(OnPressedEditableTreeTableCell.class)))) != null) {
                editingCell.commitHelper(true);
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, click -> {
            if (!this.isEmpty() && this.isEditable() && !this.isEditing() && this.getTableColumn().isEditable()) {
                this.getTreeTableView().edit(this.getIndex(), this.getTableColumn());
            }
        });
    }

    @Override
    public void startEdit() {
        super.startEdit();
        if (this.isEditing()) {
            this.getTreeTableView().getProperties().put(OnPressedEditableTreeTableCell.class, (Object)this);
        }
    }

    public void commitEdit(T newValue) {
        super.commitEdit(newValue);
        this.getTreeTableView().getProperties().remove(OnPressedEditableTreeTableCell.class);
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.getTreeTableView().getProperties().remove(OnPressedEditableTreeTableCell.class);
    }
}

