/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXToggleButton;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import javafx.animation.Interpolator;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.skin.ToggleButtonSkin;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.util.Duration;

public class JFXToggleButtonSkin
extends ToggleButtonSkin {
    private Runnable releaseManualRippler = null;
    private JFXAnimationTimer timer;
    private final Circle circle;
    private final Line line;

    public JFXToggleButtonSkin(JFXToggleButton toggleButton) {
        super((ToggleButton)toggleButton);
        double circleRadius = toggleButton.getSize();
        this.line = new Line();
        this.line.setStroke(((ToggleButton)this.getSkinnable()).isSelected() ? toggleButton.getToggleLineColor() : toggleButton.getUnToggleLineColor());
        this.line.setStartX(0.0);
        this.line.setStartY(0.0);
        this.line.setEndX(circleRadius * 2.0 + 2.0);
        this.line.setEndY(0.0);
        this.line.setStrokeWidth(circleRadius * 1.5);
        this.line.setStrokeLineCap(StrokeLineCap.ROUND);
        this.line.setSmooth(true);
        this.circle = new Circle();
        this.circle.setFill(((ToggleButton)this.getSkinnable()).isSelected() ? toggleButton.getToggleColor() : toggleButton.getUnToggleColor());
        this.circle.setCenterX(-circleRadius);
        this.circle.setCenterY(0.0);
        this.circle.setRadius(circleRadius);
        this.circle.setSmooth(true);
        JFXDepthManager.setDepth((Node)this.circle, 1);
        StackPane circlePane = new StackPane();
        circlePane.getChildren().add((Object)this.circle);
        circlePane.setPadding(new Insets(circleRadius * 1.5));
        JFXRippler rippler = new JFXRippler((Node)circlePane, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
        rippler.setRipplerFill(((ToggleButton)this.getSkinnable()).isSelected() ? toggleButton.getToggleLineColor() : toggleButton.getUnToggleLineColor());
        rippler.setTranslateX(this.computeTranslation(circleRadius, this.line));
        StackPane main = new StackPane();
        main.getChildren().setAll((Object[])new Node[]{this.line, rippler});
        main.setCursor(Cursor.HAND);
        ((ToggleButton)this.getSkinnable()).armedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.releaseManualRippler = rippler.createManualRipple();
            } else if (this.releaseManualRippler != null) {
                this.releaseManualRippler.run();
            }
        });
        toggleButton.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (!toggleButton.isDisableVisualFocus().booleanValue()) {
                if (newVal.booleanValue()) {
                    if (!((ToggleButton)this.getSkinnable()).isPressed()) {
                        rippler.setOverlayVisible(true);
                    }
                } else {
                    rippler.setOverlayVisible(false);
                }
            }
        });
        toggleButton.pressedProperty().addListener(observable -> rippler.setOverlayVisible(false));
        ((ToggleButton)this.getSkinnable()).selectedProperty().addListener(observable -> {
            rippler.setRipplerFill(toggleButton.isSelected() ? toggleButton.getToggleLineColor() : toggleButton.getUnToggleLineColor());
            if (!toggleButton.isDisableAnimation().booleanValue()) {
                this.timer.reverseAndContinue();
            } else {
                rippler.setTranslateX(this.computeTranslation(circleRadius, this.line));
            }
        });
        ((ToggleButton)this.getSkinnable()).setGraphic((Node)main);
        this.timer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis((double)100.0), JFXKeyValue.builder().setTarget(rippler.translateXProperty()).setEndValueSupplier(() -> this.computeTranslation(circleRadius, this.line)).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((JFXToggleButton)this.getSkinnable()).isDisableAnimation() == false).build(), JFXKeyValue.builder().setTarget(this.line.strokeProperty()).setEndValueSupplier(() -> ((ToggleButton)this.getSkinnable()).isSelected() ? ((JFXToggleButton)this.getSkinnable()).getToggleLineColor() : ((JFXToggleButton)this.getSkinnable()).getUnToggleLineColor()).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((JFXToggleButton)this.getSkinnable()).isDisableAnimation() == false).build(), JFXKeyValue.builder().setTarget(this.circle.fillProperty()).setEndValueSupplier(() -> ((ToggleButton)this.getSkinnable()).isSelected() ? ((JFXToggleButton)this.getSkinnable()).getToggleColor() : ((JFXToggleButton)this.getSkinnable()).getUnToggleColor()).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((JFXToggleButton)this.getSkinnable()).isDisableAnimation() == false).build()));
        this.timer.setCacheNodes(new Node[]{this.circle, this.line});
        this.registerChangeListener((ObservableValue)toggleButton.toggleColorProperty(), observableValue -> {
            if (((ToggleButton)this.getSkinnable()).isSelected()) {
                this.circle.setFill(((JFXToggleButton)this.getSkinnable()).getToggleColor());
            }
        });
        this.registerChangeListener((ObservableValue)toggleButton.unToggleColorProperty(), observableValue -> {
            if (!((ToggleButton)this.getSkinnable()).isSelected()) {
                this.circle.setFill(((JFXToggleButton)this.getSkinnable()).getUnToggleColor());
            }
        });
        this.registerChangeListener((ObservableValue)toggleButton.toggleLineColorProperty(), observableValue -> {
            if (((ToggleButton)this.getSkinnable()).isSelected()) {
                this.line.setStroke(((JFXToggleButton)this.getSkinnable()).getToggleLineColor());
            }
        });
        this.registerChangeListener((ObservableValue)toggleButton.unToggleColorProperty(), observableValue -> {
            if (!((ToggleButton)this.getSkinnable()).isSelected()) {
                this.line.setStroke(((JFXToggleButton)this.getSkinnable()).getUnToggleLineColor());
            }
        });
    }

    private double computeTranslation(double circleRadius, Line line) {
        return (double)(((ToggleButton)this.getSkinnable()).isSelected() ? 1 : -1) * (line.getLayoutBounds().getWidth() / 2.0 - circleRadius + 2.0);
    }

    public void dispose() {
        super.dispose();
        this.timer.dispose();
        this.timer = null;
    }
}

