/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.base.IFXStaticControl;
import com.jfoenix.controls.base.IFXValidatableControl;
import com.jfoenix.utils.JFXUtilities;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class ValidationPane<T extends Region & IFXStaticControl>
extends HBox {
    private Label errorLabel = new Label();
    private StackPane errorIcon = new StackPane();
    private final Rectangle errorContainerClip = new Rectangle();
    private final Scale errorClipScale = new Scale(1.0, 0.0, 0.0, 0.0);
    private Timeline errorHideTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)80.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)0, Interpolator.LINEAR)})});
    private Timeline errorShowTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)80.0), new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, Interpolator.EASE_OUT)})});
    private Timeline scale1 = new Timeline();
    private Timeline scaleLess1 = new Timeline();
    private T control;

    public ValidationPane(T control) {
        this.control = control;
        this.setManaged(false);
        this.errorLabel.getStyleClass().add((Object)"error-label");
        StackPane labelContainer = new StackPane(new Node[]{this.errorLabel});
        labelContainer.getStyleClass().add((Object)"error-label-container");
        labelContainer.setAlignment(Pos.TOP_LEFT);
        this.getChildren().setAll((Object[])new Node[]{labelContainer, this.errorIcon});
        HBox.setHgrow((Node)labelContainer, (Priority)Priority.ALWAYS);
        this.setSpacing(8.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setPadding(new Insets(4.0, 0.0, 0.0, 0.0));
        this.setVisible(false);
        this.setOpacity(0.0);
        this.errorContainerClip.getTransforms().add((Object)this.errorClipScale);
        this.setClip((Node)(((IFXStaticControl)control).isDisableAnimation() != false ? null : this.errorContainerClip));
        ((IFXValidatableControl)control).activeValidatorProperty().addListener((o, oldVal, newVal) -> {
            if (!((IFXStaticControl)control).isDisableAnimation().booleanValue()) {
                if (newVal != null) {
                    this.errorHideTransition.setOnFinished(finish -> {
                        this.showError((ValidatorBase)newVal);
                        double w = control.getWidth();
                        double errorContainerHeight = this.computeErrorHeight(this.computeErrorWidth(w));
                        if (this.errorLabel.isWrapText()) {
                            if (errorContainerHeight < this.getHeight()) {
                                this.scaleLess1.getKeyFrames().setAll((Object[])new KeyFrame[]{this.createSmallerScaleFrame(errorContainerHeight)});
                                this.scaleLess1.setOnFinished(event -> {
                                    this.updateErrorContainerSize(w, errorContainerHeight);
                                    this.errorClipScale.setY(1.0);
                                });
                                SequentialTransition transition = new SequentialTransition(new Animation[]{this.scaleLess1, this.errorShowTransition});
                                transition.play();
                            } else {
                                this.errorClipScale.setY(oldVal == null ? 0.0 : this.getHeight() / errorContainerHeight);
                                this.updateErrorContainerSize(w, errorContainerHeight);
                                this.scale1.getKeyFrames().setAll((Object[])new KeyFrame[]{this.createScaleToOneFrames()});
                                ParallelTransition parallelTransition = new ParallelTransition();
                                parallelTransition.getChildren().addAll((Object[])new Animation[]{this.scale1, this.errorShowTransition});
                                parallelTransition.play();
                            }
                        } else {
                            this.errorClipScale.setY(1.0);
                            this.updateErrorContainerSize(w, errorContainerHeight);
                            ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{this.errorShowTransition});
                            parallelTransition.play();
                        }
                    });
                    this.errorHideTransition.play();
                } else {
                    this.errorHideTransition.setOnFinished(null);
                    if (this.errorLabel.isWrapText()) {
                        this.scaleLess1.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                        this.scaleLess1.setOnFinished(event -> {
                            this.hideError();
                            this.errorClipScale.setY(0.0);
                        });
                        SequentialTransition transition = new SequentialTransition(new Animation[]{this.scaleLess1});
                        transition.play();
                    } else {
                        this.errorClipScale.setY(0.0);
                    }
                    this.errorHideTransition.play();
                }
            } else if (newVal != null) {
                JFXUtilities.runInFXAndWait(() -> this.showError((ValidatorBase)newVal));
            } else {
                JFXUtilities.runInFXAndWait(this::hideError);
            }
        });
    }

    public void layoutPane(double x, double y, double w, double h) {
        this.relocate(x, y);
        if (((IFXStaticControl)this.control).isDisableAnimation().booleanValue() || this.isErrorVisible()) {
            this.resize(w, this.computeErrorHeight(this.computeErrorWidth(w)));
            this.errorContainerClip.setWidth(w);
        }
    }

    public void invalid(double w) {
        ValidatorBase activeValidator = ((IFXValidatableControl)this.control).getActiveValidator();
        if (activeValidator != null) {
            this.showError(activeValidator);
            double errorContainerWidth = w - this.errorIcon.prefWidth(-1.0);
            this.setOpacity(1.0);
            this.resize(w, this.computeErrorHeight(errorContainerWidth));
            this.errorContainerClip.setWidth(w);
            this.errorContainerClip.setHeight(this.getHeight());
            this.errorClipScale.setY(1.0);
        }
    }

    public void updateClip() {
        this.setClip((Node)(((IFXStaticControl)this.control).isDisableAnimation() != false ? null : this.errorContainerClip));
    }

    private boolean isErrorVisible() {
        return this.isVisible() && this.errorShowTransition.getStatus().equals((Object)Animation.Status.STOPPED) && this.errorHideTransition.getStatus().equals((Object)Animation.Status.STOPPED);
    }

    private double computeErrorWidth(double w) {
        return w - this.errorIcon.prefWidth(-1.0);
    }

    private double computeErrorHeight(double errorContainerWidth) {
        return this.errorLabel.prefHeight(errorContainerWidth) + this.snappedBottomInset() + this.snappedTopInset();
    }

    private void updateErrorContainerSize(double w, double errorContainerHeight) {
        this.errorContainerClip.setWidth(w);
        this.errorContainerClip.setHeight(errorContainerHeight);
        this.resize(w, errorContainerHeight);
    }

    private KeyFrame createSmallerScaleFrame(double errorContainerHeight) {
        return new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)(errorContainerHeight / this.getHeight()), Interpolator.EASE_BOTH)});
    }

    private KeyFrame createScaleToOneFrames() {
        return new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)1, Interpolator.EASE_BOTH)});
    }

    private void showError(ValidatorBase validator) {
        this.errorLabel.setText(validator.getMessage());
        Node icon = validator.getIcon();
        this.errorIcon.getChildren().clear();
        if (icon != null) {
            this.errorIcon.getChildren().setAll((Object[])new Node[]{icon});
            StackPane.setAlignment((Node)icon, (Pos)Pos.CENTER_RIGHT);
        }
        this.setVisible(true);
    }

    private void hideError() {
        this.errorLabel.setText(null);
        this.errorIcon.getChildren().clear();
        this.setVisible(false);
    }
}

