/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.cache;

import java.io.Serializable;
import java.util.Collection;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MethodCachingInterceptor
implements MethodInterceptor {
    private CacheManager cacheManager;
    private static Logger logger = LoggerFactory.getLogger(MethodCachingInterceptor.class);

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cacheManager, (String)"A cache-manager is required. Use Manager(CacheManager) to provide one.");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        String invocationClassName = invocation.getThis().getClass().getName();
        Object result = null;
        Cache<String, Serializable> cache = this.getCache(invocation);
        String cacheKey = this.getCacheKey(arguments);
        Serializable element = null;
        if (cache != null) {
            element = (Serializable)cache.get((Object)cacheKey);
        } else {
            logger.debug("Cache not found in cache manager for class: " + invocationClassName);
        }
        if (element == null) {
            logger.debug("Calling intercepted method of class: " + invocationClassName);
            result = invocation.proceed();
            boolean isEmptyCollection = false;
            if (result != null && result instanceof Collection && ((Collection)result).isEmpty()) {
                isEmptyCollection = true;
            }
            if (cache != null && result != null && !isEmptyCollection) {
                logger.debug("Caching result in cache: " + cache.getName() + ", using key: " + cacheKey);
                cache.put((Object)cacheKey, (Object)((Serializable)result));
            }
        } else {
            logger.debug("Result found in cache: " + cache.getName() + ", using key: " + cacheKey);
            result = element;
        }
        return result;
    }

    private Cache<String, Serializable> getCache(MethodInvocation invocation) {
        String methodName = invocation.getMethod().getName();
        Class<?>[] argumentsClasses = invocation.getMethod().getParameterTypes();
        Class<?> clazz = invocation.getThis().getClass();
        String name = this.getCacheName(clazz, methodName, argumentsClasses);
        logger.debug("Looking for cache with name: " + name);
        Cache cache = this.getCacheManager().getCache(name);
        if (cache == null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length && cache == null; ++i) {
                name = this.getCacheName(interfaces[i], methodName, argumentsClasses);
                logger.debug("Looking for cache with name: " + name);
                cache = this.getCacheManager().getCache(name);
            }
        }
        if (cache != null) {
            logger.debug("Cache found: " + cache.getName());
        }
        return cache;
    }

    private String getCacheName(Class<?> clazz, String methodName, Class<?>[] argumentsClasses) {
        StringBuffer sb = new StringBuffer();
        sb.append(clazz.getName()).append(".").append(methodName).append("(");
        if (argumentsClasses != null && argumentsClasses.length != 0) {
            for (int i = 0; i < argumentsClasses.length; ++i) {
                sb.append(argumentsClasses[i].getName());
                if (i + 1 >= argumentsClasses.length) continue;
                sb.append(",");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private String getCacheKey(Object[] arguments) {
        StringBuffer sb = new StringBuffer("arguments");
        if (arguments != null && arguments.length != 0) {
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(".").append(arguments[i]);
            }
        }
        return sb.toString();
    }
}

