/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.data;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.data.StatisticDataObject;
import de.effectivecompany.base.efcbl.util.BaseDomainObject;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatisticData
extends BaseDomainObject
implements StatisticDataObject,
LazyLoader {
    private static final long serialVersionUID = -4419849163155633372L;
    private static Logger logger = LoggerFactory.getLogger(AbstractStatisticData.class);
    private Lock locked = new ReentrantLock(true);

    @Override
    public String getGroupName(int groupid) {
        return this.getGroupKey(groupid).toString();
    }

    @Override
    public int getGroupId(String groupkey) {
        for (int i = 0; i < this.getGroupCount(); ++i) {
            if (!this.getGroupKey(i).equals(groupkey)) continue;
            return i;
        }
        logger.debug("group key not found: " + groupkey);
        return 0;
    }

    @Override
    public int getDatasetId(String listkey) {
        for (int i = 0; i < this.getDatasetCount(); ++i) {
            if (!this.getDatasetKey(i).equals(listkey)) continue;
            return i;
        }
        logger.debug("dataset key not found: " + listkey);
        return 0;
    }

    @Override
    public abstract Number[] getValues(int var1, int var2);

    @Override
    public Number[] getValues(int datalist, String group) {
        return this.getValues(datalist, this.getGroupId(group));
    }

    @Override
    public Number[] getValues(String datalist, String group) {
        return this.getValues(this.getDatasetId(datalist), group);
    }

    @Override
    public void lock() {
        this.locked.lock();
    }

    @Override
    public void unlock() {
        this.locked.unlock();
    }
}

