/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.Metadata;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.datatypes.json.EFCAlphaNumericJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCAlphaNumericJsonSerializer;
import java.security.InvalidParameterException;
import java.util.Objects;

@JsonIgnoreProperties(value={"maxsize", "minsize", "metadata", "init"})
@JsonSerialize(using=EFCAlphaNumericJsonSerializer.class)
@JsonDeserialize(using=EFCAlphaNumericJsonDeserializer.class)
public class EFCAlphaNumeric
extends BaseType
implements Comparable<EFCAlphaNumeric> {
    private static final long serialVersionUID = -2201962835274204933L;
    protected String data = null;

    public EFCAlphaNumeric() {
        this((String)null);
    }

    public EFCAlphaNumeric(EFCAlphaNumeric val) {
        if (val != null) {
            this.data = val.data;
            this.putMetadata(val.getMetadata());
        }
        this.setModified(false);
    }

    public EFCAlphaNumeric(String val) {
        this.data = val;
        if (val != null) {
            this.setInitialized();
        }
        this.setModified(false);
    }

    @Override
    protected void nullData() {
        this.setModified(this.data != null);
        this.data = null;
        this.setUnInitialized();
    }

    @Override
    public Object optainValue() {
        return this.data;
    }

    @Override
    public void putValue(Object o) {
        if (this == o) {
            return;
        }
        if (o == null) {
            this.nullData();
            return;
        }
        if (o instanceof Type) {
            this.putValue(((Type)o).optainValue());
        } else if (o instanceof String) {
            this.setData((String)o);
        } else if (o instanceof Integer) {
            this.setData(((Integer)o).toString());
        } else if (o instanceof Double) {
            this.setData(((Double)o).toString());
        } else if (o instanceof Long) {
            this.setData(((Long)o).toString());
        } else {
            throw new InvalidParameterException("Could not convert value to string, class " + o.getClass().getName());
        }
        this.setInitialized();
    }

    public String getData() {
        return this.data;
    }

    public void setData(String s) {
        if (s != null && this.data != null && this.data.equals(s) || this.data == null && s == null) {
            this.setModified(false);
            return;
        }
        if (this.data != null) {
            if (s != null) {
                this.setModified(!s.equals(this.data));
            } else {
                this.setModified(true);
            }
        } else {
            this.setModified(true);
        }
        this.data = s;
        this.setInit(this.data != null);
    }

    public String toString() {
        return this.data == null ? "" : this.data;
    }

    public EFCAlphaNumeric toEFCAlphaNumeric() {
        return new EFCAlphaNumeric(this.data == null ? "" : this.data);
    }

    public EFCString toEFCString() {
        return new EFCString(this.data == null ? "" : this.data);
    }

    public EFCAlphaNumeric plus(EFCAlphaNumeric str) {
        return new EFCAlphaNumeric(this.data + str.optainValue());
    }

    public EFCAlphaNumeric plus(String str) {
        return new EFCAlphaNumeric(this.data + str);
    }

    public EFCAlphaNumeric plus(EFCString str) {
        return new EFCAlphaNumeric(this.data + str.optainValue());
    }

    public boolean equals(Object obj) {
        if (obj instanceof EFCAlphaNumeric) {
            return this.equals((EFCAlphaNumeric)obj);
        }
        if (obj instanceof EFCString) {
            return this.equals((EFCString)obj);
        }
        if (obj instanceof String) {
            String val = (String)obj;
            if (this.data == null || val == null) {
                return false;
            }
            return this.data.equals(val);
        }
        return super.equals(obj);
    }

    public boolean equals(EFCAlphaNumeric str) {
        if (str == null) {
            return false;
        }
        String val = str.getData();
        if (val == null && this.data == null) {
            return true;
        }
        if (this.data == null || val == null) {
            return false;
        }
        return this.data.equals(val);
    }

    public boolean equals(EFCString str) {
        if (str == null) {
            return false;
        }
        String val = str.getData();
        if (val == null && this.data == null) {
            return true;
        }
        if (this.data == null || val == null) {
            return false;
        }
        return this.data.equals(val);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data, this.isInitialized(), this.isModified());
    }

    @Override
    public int compareTo(EFCAlphaNumeric str) {
        if (this.data == null) {
            if (str == null || str.getData() == null) {
                return 0;
            }
            return -1;
        }
        if (str == null || str.getData() == null) {
            return 1;
        }
        return this.data.compareToIgnoreCase(str.getData());
    }

    public boolean contains(EFCAlphaNumeric v) {
        return this.contains(v.getData());
    }

    public boolean contains(EFCString v) {
        return this.contains(v.getData());
    }

    public boolean contains(CharSequence v) {
        if (this.data == null) {
            return false;
        }
        return this.data.contains(v);
    }

    public EFCAlphaNumeric clone() {
        return new EFCAlphaNumeric(this);
    }

    @Override
    public void defaults() {
        this.setData("");
    }

    public void putMetadata(Metadata meta) {
        if (meta != null) {
            this.putInit(meta.isInit());
            this.putModified(meta.isModified());
        } else {
            this.putInit(true);
            this.putModified(true);
        }
    }

    @Override
    public long getMaxsize() {
        return -1L;
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }

    @Override
    public long getMinsize() {
        return -1L;
    }
}

