/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.BaseType;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCLong;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.Metadata;
import de.effectivecompany.base.datatypes.json.EFCBooleanJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCBooleanJsonSerializer;
import java.security.InvalidParameterException;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(value={"boolean", "init", "maxsize", "minsize", "metadata"})
@JsonSerialize(using=EFCBooleanJsonSerializer.class)
@JsonDeserialize(using=EFCBooleanJsonDeserializer.class)
public final class EFCBoolean
extends BaseType
implements Comparable<EFCBoolean> {
    private static final long serialVersionUID = -891555599424529621L;
    protected Boolean data;

    public EFCBoolean() {
    }

    public EFCBoolean(Boolean b) {
        this.data = b;
        if (this.data != null) {
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCBoolean(Optional<?> val) {
        if (val != null) {
            this.data = val.isPresent();
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCBoolean(Integer val) {
        if (val != null) {
            this.data = val == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCBoolean(EFCInteger val) {
        if (val != null) {
            this.data = val.getIntValue() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCBoolean(Long val) {
        if (val != null) {
            this.data = val == 1L ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCBoolean(EFCLong val) {
        if (val != null) {
            this.data = val.getIntValue() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCBoolean(String val) {
        if (val != null) {
            if (val.equalsIgnoreCase("false")) {
                this.data = false;
            } else if (val.equalsIgnoreCase("true")) {
                this.data = true;
            } else {
                try {
                    long i = Long.parseLong(val.trim());
                    this.data = i == 1L ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                catch (NumberFormatException nfe) {
                    this.nullData();
                    return;
                }
            }
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCBoolean(EFCString val) {
        if (val != null) {
            if (val.getData().equalsIgnoreCase("false")) {
                this.data = false;
            } else if (val.getData().equalsIgnoreCase("true")) {
                this.data = true;
            } else {
                try {
                    int i = Integer.parseInt(val.getData().trim());
                    this.data = i == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                }
                catch (NumberFormatException nfe) {
                    this.nullData();
                    return;
                }
            }
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCBoolean(EFCBoolean val) {
        this();
        if (val != null) {
            this.data = val.data;
            this.putMetadata(val.getMetadata());
        }
        this.setModified(false);
    }

    public void putMetadata(Metadata meta) {
        this.putInit(meta.isInit());
        this.putModified(meta.isModified());
    }

    @Override
    public Object optainValue() {
        return this.data;
    }

    public int getInt() {
        if (this.data == null) {
            return -1;
        }
        if (this.data.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public Boolean getBoolean() {
        return this.data;
    }

    @Override
    protected void nullData() {
        this.setModified(this.data != null);
        this.data = null;
        this.setUnInitialized();
    }

    @Override
    public void putValue(Object o) {
        if (this == o) {
            return;
        }
        if (o == null) {
            this.nullData();
            return;
        }
        if (o instanceof Boolean) {
            this.setData((Boolean)o);
        } else if (o instanceof Integer) {
            this.setData((Integer)o != 0);
        } else if (o instanceof EFCBoolean) {
            if (((EFCBoolean)o).getData() == null) {
                this.nullData();
                return;
            }
            this.setData(((EFCBoolean)o).getInt() != 0);
        } else if (o instanceof String) {
            if (!((String)o).isEmpty()) {
                this.setData(!"0".equals(o));
            } else {
                this.setData(false);
            }
        } else {
            throw new InvalidParameterException("Boolean, integer or string object expected");
        }
        this.setInitialized();
    }

    public String toString() {
        if (this.data == null) {
            return "-";
        }
        if (this.data.booleanValue()) {
            return "true";
        }
        return "false";
    }

    public Integer toInteger() {
        if (this.data == null) {
            return null;
        }
        if (this.data.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public void setData(Boolean newData) {
        if (newData != null && this.data != null && this.data.equals(newData) || this.data == null && newData == null) {
            this.setModified(false);
            return;
        }
        if (this.data != null) {
            if (newData != null) {
                this.setModified(!newData.equals(this.data));
            } else {
                this.setModified(true);
            }
        } else {
            this.setModified(true);
        }
        this.data = newData;
        this.setInit(this.data != null);
    }

    public Boolean getData() {
        return this.data;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data, this.isInitialized(), this.isModified());
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof EFCBoolean) {
            if (this.data != null) {
                return this.data.equals(((EFCBoolean)otherObject).data);
            }
            return ((EFCBoolean)otherObject).data == null;
        }
        if (otherObject instanceof Boolean) {
            if (this.data != null) {
                return this.data.equals((Boolean)otherObject);
            }
            return false;
        }
        return false;
    }

    @Override
    public int compareTo(EFCBoolean i) {
        if (this.data == null && i.getData() == null) {
            return 0;
        }
        if (this.data != null && i != null && i.getData() != null) {
            return this.data.compareTo(i.getData());
        }
        if (this.data == null && i != null && i.getData() != null) {
            if (i.getData().booleanValue()) {
                return -1;
            }
            return 0;
        }
        if (this.data != null && i != null && i.getData() == null) {
            if (this.data.booleanValue()) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public boolean compareTo(boolean i) {
        return this.data == i;
    }

    public EFCBoolean clone() {
        return new EFCBoolean(this);
    }

    @Override
    public void defaults() {
        this.setData(false);
    }

    @Override
    public long getMaxsize() {
        return 1L;
    }

    @Override
    public long getMinsize() {
        return 1L;
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }
}

