/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.esotericsoftware.kryo.Kryo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.Metadata;
import de.effectivecompany.base.datatypes.json.EFCMapJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCMapJsonSerializer;
import de.effectivecompany.base.util.SerializationUtilities;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

@JsonIgnoreProperties(value={"metadata", "init", "map"})
@JsonSerialize(using=EFCMapJsonSerializer.class)
@JsonDeserialize(using=EFCMapJsonDeserializer.class)
public class EFCMap<K, V>
extends ConcurrentSkipListMap<K, V>
implements Type,
Metadata,
Map<K, V> {
    private static final long serialVersionUID = 5282697976404441107L;
    private boolean initialized = false;
    private boolean modified = false;

    public EFCMap() {
    }

    public EFCMap(Comparator<?> c) {
    }

    public EFCMap(int initialCapacity) {
    }

    public EFCMap(Map<K, V> val) {
        this();
        if (val != null) {
            Kryo kryo = SerializationUtilities.optainKryo();
            Map deepCopyData = (Map)kryo.copy(val);
            SerializationUtilities.freeKryo(kryo);
            this.putAll(deepCopyData);
            this.setInitialized();
        }
        this.setModified(false);
    }

    public EFCMap(EFCMap<K, V> val) {
        this();
        if (val != null) {
            this.putAll(val.clone());
            this.putMetadata(val.getMetadata());
            this.setInitialized();
        }
        this.setModified(false);
    }

    public Object optainValue() {
        return this;
    }

    public void putValue(Object o) {
        if (o != null && o instanceof EFCMap && this.equals(o) || o == null && this.isEmpty()) {
            this.setModified(false);
            return;
        }
        if (this == o) {
            return;
        }
        if (o == null) {
            this.nullData();
            return;
        }
        if (o instanceof EFCMap) {
            this.clear();
            for (Map.Entry e : ((EFCMap)o).entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
            this.setModified(true);
        } else if (o instanceof Map) {
            this.clear();
            for (Map.Entry e : ((Map)o).entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
            this.setModified(true);
        } else {
            throw new IllegalArgumentException("value has to be a map");
        }
        this.setInitialized();
    }

    public Map<K, V> getMap() {
        return this;
    }

    @Override
    public EFCMap<K, V> clone() {
        Kryo kryo = SerializationUtilities.optainKryo();
        EFCMap ret = (EFCMap)kryo.copy((Object)this);
        SerializationUtilities.freeKryo(kryo);
        return ret;
    }

    @Override
    public boolean isInit() {
        return this.initialized;
    }

    @Override
    public void putInit(boolean isInit) {
        this.initialized = isInit;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void putModified(boolean isModified) {
        this.initialized = isModified;
    }

    public void setInitialized() {
        this.putInit(true);
    }

    public void setUnInitialized() {
        this.putInit(false);
    }

    public boolean isInitialized() {
        return this.isInit();
    }

    public void setModified(boolean isModified) {
        this.modified = isModified;
    }

    @Override
    public long getMaxsize() {
        return this.size();
    }

    @Override
    public void putMaxsize(long maxsize) {
        throw new RuntimeException("putMaxsize call not allowed");
    }

    @Override
    public long getMinsize() {
        return this.size();
    }

    @Override
    public void putMinsize(long minsize) {
        throw new RuntimeException("putMinsize call not allowed");
    }

    public Metadata getMetadata() {
        return this;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = hash * 17 + Boolean.valueOf(this.initialized).hashCode();
        hash = hash * 13 + Boolean.valueOf(this.modified).hashCode();
        hash = hash * 23 + super.hashCode();
        return hash;
    }

    @Override
    public V put(K key, V val) {
        if (!this.containsKey(key)) {
            this.setModified(true);
        } else {
            this.setModified(!this.get(key).equals(val));
        }
        this.setInitialized();
        return super.put(key, val);
    }

    public Type[] getParameterizedTypes() {
        Type superclassType = this.getClass().getGenericSuperclass();
        if (!ParameterizedType.class.isAssignableFrom(superclassType.getClass())) {
            return null;
        }
        return ((ParameterizedType)superclassType).getActualTypeArguments();
    }

    public void putMetadata(Metadata meta) {
        this.putInit(meta.isInit());
        this.putModified(meta.isModified());
    }

    protected void nullData() {
        this.setModified(!this.isEmpty());
        this.clear();
        this.setUnInitialized();
    }
}

