/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.OptionMetadata;
import de.effectivecompany.base.datatypes.OptionObject;
import de.effectivecompany.base.datatypes.json.EFCOptionJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCOptionJsonSerializer;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(value={"maxsize", "minsize", "metadata", "init", "bytevalue", "doublevalue", "floatvalue", "intvalue", "longvalue"})
@JsonSerialize(using=EFCOptionJsonSerializer.class)
@JsonDeserialize(using=EFCOptionJsonDeserializer.class)
public final class EFCOption
extends EFCInteger
implements OptionMetadata {
    private static final long serialVersionUID = -721482588175637094L;
    private Class<?> metaOptions;

    public EFCOption(Integer i) {
        this(OptionObject.class, i);
    }

    public EFCOption(EFCInteger i) {
        this(OptionObject.class, i);
    }

    public EFCOption(String i) {
        this(OptionObject.class, i);
    }

    public EFCOption(EFCString i) {
        this(OptionObject.class, i);
    }

    public EFCOption() {
        this(OptionObject.class);
    }

    public EFCOption(Class<?> options, Integer option) {
        super(option);
        this.putMetaOptions(options);
    }

    public EFCOption(Class<?> options, EFCInteger option) {
        super(option);
        this.putMetaOptions(options);
    }

    public EFCOption(Class<?> options, String option) {
        super(option);
        this.putMetaOptions(options);
    }

    public EFCOption(Class<?> options, EFCString option) {
        super(option);
        this.putMetaOptions(options);
    }

    public EFCOption(Class<?> options) {
        this(options, OptionObject.getDefaultOption(options));
    }

    public EFCOption(EFCOption original) {
        super(original);
        if (original != null) {
            this.metaOptions = original.metaOptions;
        }
    }

    public Map<String, Integer> getOptionValues() {
        return OptionObject.getValues(this.getOptionClass());
    }

    public Class<?> getMetaOptions() {
        return this.metaOptions;
    }

    public void putMetaOptions(Class<?> options) {
        this.metaOptions = options;
    }

    public Class<?> getOptionClass() {
        if (!(this.getMetadata() instanceof OptionMetadata)) {
            this.putDefaultMetadata();
        }
        return this.metaOptions;
    }

    public void putOptionClass(Class<?> c) {
        if (!(this.getMetadata() instanceof OptionMetadata)) {
            this.putDefaultMetadata();
        }
        this.metaOptions = c;
    }

    @Override
    public String toString() {
        if (this.optainValue() == null) {
            return "";
        }
        try {
            for (Map.Entry<String, Integer> e : this.getOptionValues().entrySet()) {
                if (e.getValue().intValue() != this.getIntValue().intValue()) continue;
                return e.getKey();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.optainValue().toString();
    }

    @Override
    public EFCOption clone() {
        return new EFCOption(this);
    }

    private void putDefaultMetadata() {
        this.metaOptions = OptionObject.class;
    }

    @Override
    public void putOptions(Class<?> options) {
        this.putMetaOptions(options);
    }

    @Override
    public Class<?> getOptions() {
        return this.getMetaOptions();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isInitialized(), this.isModified(), this.metaOptions) + 7 * super.hashCode();
    }
}

