/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.EFCAlphaNumeric;
import de.effectivecompany.base.datatypes.Metadata;
import de.effectivecompany.base.datatypes.json.EFCStringJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCStringJsonSerializer;
import java.util.Objects;

@JsonIgnoreProperties(value={"maxsize", "minsize", "metadata", "init"})
@JsonSerialize(using=EFCStringJsonSerializer.class)
@JsonDeserialize(using=EFCStringJsonDeserializer.class)
public class EFCString
extends EFCAlphaNumeric {
    private static final long serialVersionUID = -2201962835274204933L;
    private long meta_minsize = 0L;
    private long meta_maxsize = -1L;

    public EFCString() {
        this(0L, -1L, (String)null);
    }

    public EFCString(String val) {
        this(0L, -1L, val);
    }

    public EFCString(EFCString val) {
        super(val);
    }

    public EFCString(EFCAlphaNumeric val) {
        super(val);
    }

    public EFCString(long maxsize) {
        this(0L, maxsize);
    }

    public EFCString(long minsize, long maxsize) {
        this(minsize, maxsize, (String)null);
    }

    public EFCString(long minsize, long maxsize, EFCString val) {
        super(val);
        Metadata m = this.getMetadata();
        m.putMinsize(minsize);
        m.putMaxsize(maxsize);
        this.meta_maxsize = maxsize;
        this.meta_minsize = minsize;
    }

    public EFCString(long minsize, long maxsize, String val) {
        super(val);
        Metadata m = this.getMetadata();
        m.putMinsize(minsize);
        m.putMaxsize(maxsize);
        this.meta_maxsize = maxsize;
        this.meta_minsize = minsize;
    }

    @Override
    public long getMaxsize() {
        return this.meta_maxsize;
    }

    @Override
    public void putMaxsize(long maxsize) {
        this.meta_maxsize = maxsize;
    }

    @Override
    public long getMinsize() {
        return this.meta_minsize;
    }

    @Override
    public void putMinsize(long minsize) {
        this.meta_minsize = minsize;
    }

    @Override
    public EFCString clone() {
        return new EFCString(this);
    }

    @Override
    public void defaults() {
        this.setData("");
    }

    @Override
    public void putMetadata(Metadata meta) {
        if (meta != null) {
            this.putMaxsize(meta.getMaxsize());
            this.putInit(meta.isInit());
            this.putMinsize(meta.getMinsize());
            this.putModified(meta.isModified());
        }
    }

    @Override
    public EFCString plus(EFCAlphaNumeric str) {
        EFCString ret = new EFCString(this.getData() + str.optainValue());
        return ret;
    }

    @Override
    public EFCString plus(String str) {
        EFCString ret = new EFCString(this.getData() + str);
        return ret;
    }

    @Override
    public EFCString plus(EFCString str) {
        EFCString ret = new EFCString(this.getData() + str.optainValue());
        return ret;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.meta_maxsize, this.meta_minsize) + super.hashCode();
    }
}

