/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.json.EFCTimeJsonDeserializer;
import de.effectivecompany.base.datatypes.json.EFCTimeJsonSerializer;
import java.util.Date;

@JsonIgnoreProperties(value={"date", "datetimeinmillis", "maxsize", "minsize", "metadata"})
@JsonSerialize(using=EFCTimeJsonSerializer.class)
@JsonDeserialize(using=EFCTimeJsonDeserializer.class)
public final class EFCTime
extends EFCDateTime {
    private static final long serialVersionUID = 9008866485701558693L;

    public EFCTime() {
    }

    public EFCTime(Long date) {
        this(new Date(date));
    }

    public EFCTime(Date date) {
        this();
        if (date != null) {
            this.putValue(date.getTime());
        }
    }

    public EFCTime(EFCDate date) {
        this();
        this.putValue(date);
    }

    public EFCTime(String date) {
        this();
        if ("".equals(date) || "null".equals(date)) {
            this.putValue(null);
        } else {
            this.putValue(date);
        }
    }

    public EFCTime(EFCString date) {
        this();
        this.putValue(date);
    }

    public EFCTime(EFCTime val) {
        this();
        this.putValue(val);
        if (val != null) {
            this.putMetadata(val.getMetadata());
        }
    }

    @Override
    public EFCTime clone() {
        return new EFCTime(this);
    }

    @Override
    public String toString() {
        if (this.data == null) {
            return "";
        }
        return formatTime.format(this.getDate());
    }
}

