/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.awt.Color;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ColorMapDeserializer
extends JsonDeserializer<Map<String, Color>> {
    public Map<String, Color> deserialize(JsonParser jp, DeserializationContext arg1) throws IOException, JsonProcessingException {
        ObjectCodec oc = jp.getCodec();
        ArrayNode array = (ArrayNode)oc.readTree(jp);
        Iterator nodes = array.elements();
        ConcurrentHashMap<String, Color> ret = new ConcurrentHashMap<String, Color>();
        while (nodes.hasNext()) {
            JsonNode node = (JsonNode)nodes.next();
            JsonNode color = node.get("color");
            ret.put(node.get("name").textValue(), new Color(color.get("red").intValue(), color.get("green").intValue(), color.get("blue").intValue()));
        }
        return ret;
    }
}

