/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.datatypes.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.json.Utils;
import java.io.IOException;

public class EFCListJsonSerializer
extends JsonSerializer<EFCList<?>> {
    public void serialize(EFCList<?> obj, JsonGenerator jgen, SerializerProvider arg2) throws IOException, JsonProcessingException {
        if (obj != null && obj.getList() != null) {
            jgen.writeStartObject();
            jgen.writeArrayFieldStart("data");
            String valueType = null;
            for (Object o : obj) {
                jgen.writeObject(o);
                if (valueType != null || o == null) continue;
                valueType = o.getClass().getName();
            }
            jgen.writeEndArray();
            Utils.writeBaseAttributes(jgen, obj);
            if (valueType != null) {
                jgen.writeStringField("javaValueType", valueType);
            }
            jgen.writeEndObject();
        } else {
            jgen.writeNull();
        }
    }
}

