/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.efcbl.error;

import de.effectivecompany.base.efcbl.error.ApplicationException;
import de.effectivecompany.base.efcbl.error.ServiceContext;
import de.effectivecompany.base.efcbl.error.ServiceContextStore;
import de.effectivecompany.base.efcbl.error.SystemException;

public class LogMessage {
    private String errorCode;
    private String message;
    private ServiceContext serviceContext;

    public LogMessage(ServiceContext serviceContext, String errorCode, String message) {
        this.serviceContext = serviceContext;
        this.errorCode = errorCode;
        this.message = message;
    }

    public LogMessage(String errorCode, String message) {
        this(ServiceContextStore.get(), errorCode, message);
    }

    public LogMessage(ServiceContext serviceContext, SystemException e) {
        this(serviceContext, e.getErrorCode(), e.getMessage());
    }

    public LogMessage(SystemException e) {
        this(ServiceContextStore.get(), e.getErrorCode(), e.getMessage());
    }

    public LogMessage(ServiceContext serviceContext, ApplicationException e) {
        this(serviceContext, e.getErrorCode(), e.getMessage());
    }

    public LogMessage(ApplicationException e) {
        this(ServiceContextStore.get(), e.getErrorCode(), e.getMessage());
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(this.errorCode).append("] ");
        if (this.serviceContext != null) {
            sb.append(this.serviceContext).append(" ");
        }
        sb.append(" : ").append(this.message);
        return sb.toString();
    }
}

