/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.efcbl.error;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ServiceContext
implements Serializable {
    private static final long serialVersionUID = 6953254895524422542L;
    private String userId = null;
    private String sessionId = null;
    private String applicationId = null;
    private Map<String, Serializable> properties = null;
    private Set<String> roles = Collections.EMPTY_SET;

    public ServiceContext(String userId, String sessionId, String applicationId) {
        this.userId = userId;
        this.sessionId = sessionId;
        this.applicationId = applicationId;
    }

    public ServiceContext(String userId, String sessionId, String applicationId, Set<String> roles) {
        this(userId, sessionId, applicationId);
        this.roles = roles;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public Serializable getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public void setProperty(String key, Serializable value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        this.properties.put(key, value);
    }

    public Iterator<String> getPropertyKeys() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        return this.properties.keySet().iterator();
    }

    public String toString() {
        if (this.properties == null) {
            return "user-id=" + this.userId + ", session-id=" + this.sessionId + ", application-id=" + this.applicationId;
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("user-id=" + this.userId + ", session-id=" + this.sessionId + ", application-id=" + this.applicationId);
        for (String key : this.properties.keySet()) {
            sbuf.append(", " + key + "=" + this.properties.get(key));
        }
        return sbuf.toString();
    }
}

