/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.efcbl.error;

import de.effectivecompany.base.efcbl.error.ServiceContext;
import de.effectivecompany.base.efcbl.error.ServiceContextStore;
import de.effectivecompany.base.efcbl.util.FactoryConfiguration;
import de.effectivecompany.base.efcbl.util.FactoryHelper;
import java.util.Random;
import java.util.Set;
import javax.security.auth.Subject;

public abstract class ServiceContextFactory {
    private static final int MAX_GENERATED_SESSION_ID = 1000000;
    private static final String SYSTEM_USER = "system";
    private static final String GUEST_USER = "guest";
    private static Random randomGenerator = new Random(System.currentTimeMillis());
    private static ServiceContextFactory singletonInstance;
    private static FactoryConfiguration config;

    protected ServiceContextFactory() {
    }

    public static void setConfiguration(FactoryConfiguration aConfig) {
        config = aConfig;
    }

    private static ServiceContextFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = ServiceContextFactory.createInstance();
        }
        return singletonInstance;
    }

    private static ServiceContextFactory createInstance() {
        return (ServiceContextFactory)FactoryHelper.newInstanceFromName(config.getFactoryImplementationClassName());
    }

    protected abstract Subject activeSubject();

    protected abstract String userIdFromSubject(Subject var1);

    protected abstract Set<String> rolesFromSubject(Subject var1);

    public static ServiceContext createServiceContext(String applicationId) {
        return ServiceContextFactory.getInstance().createServiceContextImpl(applicationId);
    }

    protected ServiceContext createServiceContextImpl(String applicationId) {
        ServiceContext context = ServiceContextStore.get();
        if (context != null) {
            return context;
        }
        String sessionId = String.valueOf(randomGenerator.nextInt(1000000));
        String userId = SYSTEM_USER;
        context = new ServiceContext(userId, sessionId, applicationId);
        return context;
    }

    static {
        config = new FactoryConfiguration(){

            @Override
            public String getFactoryImplementationClassName() {
                return "de.effectivecompany.base.efcbl.error.TestNGServiceContextFactory";
            }
        };
    }
}

