/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.gui.scroll;

import de.effectivecompany.base.gui.interfaces.FieldColumnInfo;
import de.effectivecompany.base.gui.interfaces.ScrollList;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.gui.scroll.ScrollListData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class EFCScrollList
implements ScrollList,
Serializable,
FieldColumnInfo {
    private static final long serialVersionUID = 4862478387119096447L;
    private List<ScrollListData> data = new LinkedList<ScrollListData>();
    private int row = 0;
    private List<String> columns;
    private List<String> keys;

    public EFCScrollList(Enum<?>[] cols, Enum<?>[] keyCols) {
        int i;
        this.columns = new ArrayList<String>(cols.length);
        for (i = 0; i < cols.length; ++i) {
            this.columns.add(i, cols[i].name());
        }
        if (keyCols != null) {
            this.keys = new ArrayList<String>(keyCols.length);
            for (i = 0; i < keyCols.length; ++i) {
                this.keys.add(i, keyCols[i].name());
            }
        }
    }

    @Override
    public boolean add(ScrollListData value) {
        return this.data.add(value);
    }

    @Override
    public ScrollListData get(int index) {
        return this.data.get(index);
    }

    @Override
    public ScrollListData get() {
        return this.data.get(this.row);
    }

    @Override
    public int find(Key k) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.data.get(i).getKey().equals(k)) continue;
            this.row = i;
            return i;
        }
        return -1;
    }

    @Override
    public void first() {
        this.row = 0;
    }

    @Override
    public void next() {
        ++this.row;
        if (this.row >= this.size()) {
            this.first();
        }
    }

    @Override
    public void previous() {
        --this.row;
        if (this.row < 0) {
            this.last();
        }
    }

    @Override
    public void last() {
        this.row = this.size() - 1;
    }

    @Override
    public boolean previousEqual(String field, Object value) {
        boolean found = false;
        String fieldString = "";
        Collections.reverse(this.data);
        for (ScrollListData scrollListData : this.data) {
            fieldString = scrollListData.getValue(field);
            if (!fieldString.startsWith(value.toString()) && !fieldString.toLowerCase().startsWith(value.toString().toLowerCase())) continue;
            found = true;
            this.row = this.data.indexOf(scrollListData);
            break;
        }
        Collections.reverse(this.data);
        return found;
    }

    @Override
    public boolean previousSmaller(String field, Object value) {
        String fieldString = "";
        Integer minLexicalGap = Integer.MIN_VALUE;
        Integer minScrollListIndex = null;
        for (int i = 0; i < this.data.size(); ++i) {
            fieldString = this.data.get(i).getValue(field);
            int difference = fieldString.compareTo(value.toString());
            if (difference > 0 || difference <= minLexicalGap) continue;
            minLexicalGap = difference;
            minScrollListIndex = i;
        }
        if (minScrollListIndex != null) {
            this.row = minScrollListIndex;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextEqual(String field, Object value) {
        String fieldString = "";
        boolean found = false;
        for (ScrollListData scrollListData : this.data) {
            fieldString = scrollListData.getValue(field);
            if (!fieldString.startsWith(value.toString()) && !fieldString.toLowerCase().startsWith(value.toString().toLowerCase())) continue;
            found = true;
            this.row = this.data.indexOf(scrollListData);
            break;
        }
        return found;
    }

    @Override
    public boolean nextGreater(String field, Object value) {
        String fieldString = "";
        Integer minLexicalGap = Integer.MAX_VALUE;
        Integer minScrollListIndex = null;
        for (int i = 0; i < this.data.size(); ++i) {
            fieldString = this.data.get(i).getValue(field);
            int difference = fieldString.compareTo(value.toString());
            if (difference < 0 || difference >= minLexicalGap) continue;
            minLexicalGap = difference;
            minScrollListIndex = i;
        }
        if (minScrollListIndex != null) {
            this.row = minScrollListIndex;
            return true;
        }
        return false;
    }

    @Override
    public ScrollListData remove(int key) {
        return this.data.remove(key);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public int getPosition() {
        return this.row;
    }

    @Override
    public void setPosition(int position) {
        this.row = position;
        if (this.row > this.size()) {
            this.row = this.size() - 1;
        }
    }

    @Override
    public void add(int index, ScrollListData element) {
        this.data.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends ScrollListData> c) {
        return this.data.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends ScrollListData> c) {
        return this.data.addAll(index, c);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.data.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<ScrollListData> iterator() {
        return this.data.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.data.lastIndexOf(o);
    }

    @Override
    public ListIterator<ScrollListData> listIterator() {
        return this.data.listIterator();
    }

    @Override
    public ListIterator<ScrollListData> listIterator(int index) {
        return this.data.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.data.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.data.retainAll(c);
    }

    @Override
    public ScrollListData set(int index, ScrollListData element) {
        return this.data.set(index, element);
    }

    @Override
    public List<ScrollListData> subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    @Override
    public int getIndexForField(String fieldName) {
        return this.columns.indexOf(fieldName);
    }

    @Override
    public String getFieldNameForIndex(int fieldIndex) {
        return this.columns.get(fieldIndex);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getKeyColumnCount() {
        if (this.keys != null) {
            return this.keys.size();
        }
        return 0;
    }

    @Override
    public int getIndexForKeyField(String keyFieldName) {
        if (this.keys != null) {
            return this.keys.indexOf(keyFieldName);
        }
        return 0;
    }

    @Override
    public String getKeyFieldNameForIndex(int keyFieldIndex) {
        if (this.keys != null) {
            return this.keys.get(keyFieldIndex);
        }
        return null;
    }

    @Override
    public boolean keyContainsName(String keyName) {
        if (this.keys != null) {
            return this.keys.contains(keyName);
        }
        return false;
    }
}

