/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.gui.scroll;

import de.effectivecompany.base.gui.interfaces.FieldColumnInfo;
import de.effectivecompany.base.gui.key.Key;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ScrollListData
implements Serializable {
    private static final long serialVersionUID = -7315659357692572613L;
    private List<String> m_data;
    private FieldColumnInfo columnInfo;

    public ScrollListData(FieldColumnInfo colInfo) {
        this.m_data = new ArrayList<String>(colInfo.getColumnCount());
        for (int i = 0; i < colInfo.getColumnCount(); ++i) {
            this.m_data.add("");
        }
        this.columnInfo = colInfo;
    }

    public Map<String, String> getKeys() {
        HashMap<String, String> ret = new HashMap<String, String>();
        int fieldIndex = 0;
        for (String data : this.m_data) {
            if (this.columnInfo.keyContainsName(this.columnInfo.getFieldNameForIndex(fieldIndex))) {
                ret.put(this.columnInfo.getFieldNameForIndex(fieldIndex), data);
            }
            ++fieldIndex;
        }
        return ret;
    }

    public Key getKey() {
        Key ret = new Key();
        int fieldIndex = 0;
        for (String data : this.m_data) {
            if (this.columnInfo.keyContainsName(this.columnInfo.getFieldNameForIndex(fieldIndex))) {
                ret.addKeyValue(this.columnInfo.getFieldNameForIndex(fieldIndex), data);
            }
            ++fieldIndex;
        }
        return ret;
    }

    public Map<String, String> getData() {
        HashMap<String, String> ret = new HashMap<String, String>();
        int fieldIndex = 0;
        for (String data : this.m_data) {
            ret.put(this.columnInfo.getFieldNameForIndex(fieldIndex), data);
            ++fieldIndex;
        }
        return ret;
    }

    public String getKeyValue(String field) {
        return this.getValue(field);
    }

    public void addValue(Enum<?> field, String value) {
        this.m_data.set(field.ordinal(), value);
    }

    public String getValue(String field) {
        return this.m_data.get(this.columnInfo.getIndexForField(field));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScrollListData && this.m_data.equals(((ScrollListData)obj).getData().values())) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.m_data, this.columnInfo);
    }
}

